/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.interception;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.interception.FlowInterceptor;
import org.mule.runtime.api.interception.FlowInterceptorFactory;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.http.api.HttpService;
import org.mule.tck.junit4.matcher.ErrorTypeMatcher;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.probe.PollingProber;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Interception API")
@Story(value="Flow Interception Story")
public class FlowInterceptorFactoryTestCase
extends AbstractIntegrationTestCase {
    private static CountDownLatch latch;
    @Rule
    public ExpectedError expectedError = ExpectedError.none();
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Inject
    @Named(value="withMaxConcurrency")
    public Flow withMaxConcurrency;

    protected String getConfigFile() {
        return "org/mule/test/integration/interception/flow-interceptor-factory.xml";
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        objects.put("_BeforeWithCallbackInterceptorFactory", new BeforeWithCallbackInterceptorFactory());
        objects.put("_AfterWithCallbackInterceptorFactory", new AfterWithCallbackInterceptorFactory());
        objects.put("_HasInjectedAttributesInterceptorFactory", new HasInjectedAttributesInterceptorFactory(false));
        objects.put("_EvaluatesExpressionInterceptorFactory", new EvaluatesExpressionInterceptorFactory());
        objects.put("_muleFlowInterceptorFactoryOrder", () -> Arrays.asList(BeforeWithCallbackInterceptorFactory.class.getName(), AfterWithCallbackInterceptorFactory.class.getName(), HasInjectedAttributesInterceptorFactory.class.getName(), EvaluatesExpressionInterceptorFactory.class.getName()));
        return objects;
    }

    @Before
    public void before() {
        latch = new CountDownLatch(1);
    }

    @After
    public void after() {
        HasInjectedAttributesInterceptor.interceptionParameters.clear();
        BeforeWithCallbackInterceptor.callback = event -> {};
        AfterWithCallbackInterceptor.callback = (event, thrown) -> {};
    }

    @Test
    public void proceedFlowFailing() throws Exception {
        AtomicBoolean afterCallbackRun = new AtomicBoolean();
        AfterWithCallbackInterceptor.callback = (event, thrown) -> {
            Assert.assertThat((Object)thrown.isPresent(), (Matcher)Matchers.is((Object)true));
            ErrorType errorType = ((Error)event.getError().get()).getErrorType();
            Assert.assertThat((Object)errorType.getNamespace(), (Matcher)Matchers.is((Object)"APP"));
            Assert.assertThat((Object)errorType.getIdentifier(), (Matcher)Matchers.is((Object)"ERROR"));
            afterCallbackRun.set(true);
        };
        this.flowRunner("flowFailing").runExpectingException(ErrorTypeMatcher.errorType((String)"APP", (String)"ERROR"));
        Assert.assertThat((Object)afterCallbackRun.get(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void proceedFlowHandleAndFail() throws Exception {
        AtomicBoolean afterCallbackRun = new AtomicBoolean();
        AfterWithCallbackInterceptor.callback = (event, thrown) -> {
            Assert.assertThat((Object)thrown.isPresent(), (Matcher)Matchers.is((Object)true));
            ErrorType errorType = ((Error)event.getError().get()).getErrorType();
            Assert.assertThat((Object)errorType.getNamespace(), (Matcher)Matchers.is((Object)"APP"));
            Assert.assertThat((Object)errorType.getIdentifier(), (Matcher)Matchers.is((Object)"ERROR"));
            afterCallbackRun.set(true);
        };
        this.flowRunner("flowHandleAndFail").runExpectingException(ErrorTypeMatcher.errorType((String)"APP", (String)"ERROR"));
        Assert.assertThat((Object)afterCallbackRun.get(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    @Story(value="Backpressure")
    public void flowInterceptorAppliedAfterBackpressureCheck() throws MuleException, InterruptedException {
        AtomicInteger beforeCounter = new AtomicInteger();
        BeforeWithCallbackInterceptor.callback = event -> beforeCounter.incrementAndGet();
        this.withMaxConcurrency.start();
        Thread.sleep(1500L);
        Assert.assertThat((Object)beforeCounter.get(), (Matcher)Matchers.is((Object)1));
        latch.countDown();
        PollingProber.probe(() -> beforeCounter.get() > 1);
    }

    protected boolean isGracefulShutdown() {
        return true;
    }

    public static Object await(Object payload) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return payload;
    }

    public static class AfterWithCallbackInterceptor
    implements FlowInterceptor {
        static BiConsumer<InterceptionEvent, Optional<Throwable>> callback = (event, thrown) -> {};

        public void after(String location, InterceptionEvent event, Optional<Throwable> thrown) {
            callback.accept(event, thrown);
        }
    }

    public static class AfterWithCallbackInterceptorFactory
    implements FlowInterceptorFactory {
        public FlowInterceptor get() {
            return new AfterWithCallbackInterceptor();
        }
    }

    public static class BeforeWithCallbackInterceptor
    implements FlowInterceptor {
        static Consumer<InterceptionEvent> callback = event -> {};

        public void before(String location, InterceptionEvent event) {
            callback.accept(event);
        }
    }

    public static class BeforeWithCallbackInterceptorFactory
    implements FlowInterceptorFactory {
        public FlowInterceptor get() {
            return new BeforeWithCallbackInterceptor();
        }
    }

    public static class EvaluatesExpressionInterceptor
    implements FlowInterceptor {
        private final MuleExpressionLanguage expressionEvaluator;

        public EvaluatesExpressionInterceptor(MuleExpressionLanguage expressionEvaluator) {
            this.expressionEvaluator = expressionEvaluator;
        }

        public void before(String location, InterceptionEvent event) {
            try {
                this.expressionEvaluator.evaluate("vars.addedVar", event.asBindingContext());
            }
            catch (ExpressionRuntimeException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Unable to resolve reference of addedVar"));
            }
            event.addVariable("addedVar", (Object)"value1");
            Assert.assertThat((Object)this.expressionEvaluator.evaluate("vars.addedVar", event.asBindingContext()).getValue(), (Matcher)Matchers.is((Object)"value1"));
            event.addVariable("addedVar", (Object)"value2");
            Assert.assertThat((Object)this.expressionEvaluator.evaluate("vars.addedVar", event.asBindingContext()).getValue(), (Matcher)Matchers.is((Object)"value2"));
        }
    }

    public static class EvaluatesExpressionInterceptorFactory
    implements FlowInterceptorFactory {
        @Inject
        private MuleExpressionLanguage expressionEvaluator;

        public FlowInterceptor get() {
            return new EvaluatesExpressionInterceptor(this.expressionEvaluator);
        }

        public boolean intercept(String location) {
            return location.equals("expressionsInInterception");
        }
    }

    public static class InterceptionParameters {
        private final ComponentLocation location;
        private final Map<String, ProcessorParameterValue> parameters;
        private final InterceptionEvent event;

        public InterceptionParameters(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event) {
            this.location = location;
            this.parameters = parameters;
            this.event = event;
        }

        public ComponentLocation getLocation() {
            return this.location;
        }

        public Map<String, ProcessorParameterValue> getParameters() {
            return this.parameters;
        }

        public InterceptionEvent getEvent() {
            return this.event;
        }

        public String toString() {
            return "InterceptionParameters{location: '" + this.location.getLocation() + "'; parameters: " + this.parameters + "}";
        }
    }

    public static class HasInjectedAttributesInterceptor
    implements FlowInterceptor {
        static final List<InterceptionParameters> interceptionParameters = new LinkedList<InterceptionParameters>();
        private final MuleExpressionLanguage expressionEvaluator;
        private final LockFactory lockFactory;
        private final HttpService httpService;
        private final ErrorTypeRepository errorTypeRepository;
        private final SchedulerService schedulerService;
        private final Registry registry;
        private final boolean mutateEventBefore;

        public HasInjectedAttributesInterceptor(MuleExpressionLanguage expressionEvaluator, LockFactory lockFactory, HttpService httpService, ErrorTypeRepository errorTypeRepository, SchedulerService schedulerService, Registry registry, boolean mutateEventBefore) {
            this.expressionEvaluator = expressionEvaluator;
            this.lockFactory = lockFactory;
            this.httpService = httpService;
            this.errorTypeRepository = errorTypeRepository;
            this.schedulerService = schedulerService;
            this.registry = registry;
            this.mutateEventBefore = mutateEventBefore;
        }

        public synchronized void before(String location, InterceptionEvent event) {
            Assert.assertThat((Object)this.expressionEvaluator, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
            Assert.assertThat((Object)this.lockFactory, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
            Assert.assertThat((Object)this.httpService, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
            Assert.assertThat((Object)this.errorTypeRepository, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
            Assert.assertThat((Object)this.schedulerService, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
            Assert.assertThat((Object)this.registry, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
            if (this.mutateEventBefore) {
                event.addVariable("mutated", (Object)Math.random());
            }
        }
    }

    public static class HasInjectedAttributesInterceptorFactory
    implements FlowInterceptorFactory {
        @Inject
        private MuleExpressionLanguage expressionEvaluator;
        @Inject
        private LockFactory lockFactory;
        @Inject
        private HttpService httpService;
        @Inject
        private ErrorTypeRepository errorTypeRepository;
        @Inject
        private SchedulerService schedulerService;
        @Inject
        private Registry registry;
        private final boolean mutateEventBefore;

        public HasInjectedAttributesInterceptorFactory(boolean mutateEventBefore) {
            this.mutateEventBefore = mutateEventBefore;
        }

        public FlowInterceptor get() {
            return new HasInjectedAttributesInterceptor(this.expressionEvaluator, this.lockFactory, this.httpService, this.errorTypeRepository, this.schedulerService, this.registry, this.mutateEventBefore);
        }
    }
}

