/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.runner.RunnerDelegateTo;
import org.mule.tests.api.TestQueueManager;

@Feature(value="Scope")
@Stories(value={@Story(value="Async"), @Story(value="Error Handling")})
@Issue(value="MULE-18353")
@RunnerDelegateTo(value=Parameterized.class)
public class AsyncTryTestCase
extends AbstractIntegrationTestCase {
    private final String flowName;
    private Latch latch;
    @Inject
    private TestQueueManager queueManager;

    @Parameterized.Parameters(name="{0}")
    public static Collection<String> data() {
        return Arrays.asList("trigger-sync", "trigger-async-direct", "trigger-async-flow", "trigger-async-subflow", "trigger-async-subflow", "trigger-async-subflow", "trigger-async-subflow", "trigger-simplified");
    }

    public AsyncTryTestCase(String flowName) {
        this.flowName = flowName;
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/async-try-config.xml";
    }

    @Before
    public void setupLatch() {
        this.latch = new Latch();
    }

    @Test
    public void executesTheProcessorAfterTry() throws Exception {
        ((FlowRunner)this.flowRunner(this.flowName).withVariable("latch", (Object)this.latch)).run();
        this.latch.await(5000L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)this.queueManager.read("invocationQueue", 5000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
    }
}

