/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.el;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsIterableContaining;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.MessageMatchers;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Expression Language")
@Story(value="Support Functions")
public class ExpressionLanguageFunctionsTestCase
extends AbstractIntegrationTestCase {
    public static final String API_RESPONSE = "{\n  \"name\": \"Ana\",\n  \"location\": \"BA\"\n}";
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Rule
    public ExpectedError expectedError = ExpectedError.none();

    protected String getConfigFile() {
        return "org/mule/test/el/expression-language-functions-config.xml";
    }

    @Test
    public void lookupCallsFlow() throws Exception {
        Assert.assertThat((Object)this.flowRunner("staticParams").keepStreamsOpen().run().getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)Matchers.equalTo((Object)API_RESPONSE)));
    }

    @Test
    public void lookupUsesJavaTypeRegardlessOfMessageType() throws Exception {
        TypedValue result = ((FlowRunner)((FlowRunner)this.flowRunner("complex").withPayload((Object)"{\"hey\" : \"there\"}")).withMediaType(MediaType.JSON)).keepStreamsOpen().run().getMessage().getPayload();
        Collection value = (Collection)result.getValue();
        Assert.assertThat((Object)value, (Matcher)IsIterableContaining.hasItems((Object[])new String[]{"oh", "there"}));
        Assert.assertThat((Object)result.getDataType().getMediaType(), (Matcher)Matchers.is((Object)MediaType.APPLICATION_JAVA.withCharset(StandardCharsets.UTF_8)));
    }

    @Test
    public void lookupCallsFlowThroughExpressions() throws Exception {
        Assert.assertThat((Object)((FlowRunner)((FlowRunner)this.flowRunner("expressionParams").withVariable("flow", (Object)"callApi")).withPayload((Object)"test")).keepStreamsOpen().run().getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)Matchers.equalTo((Object)API_RESPONSE)));
    }

    @Test
    public void lookupResultCanBeManipulated() throws Exception {
        Assert.assertThat((Object)this.flowRunner("composition").keepStreamsOpen().run().getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)Matchers.equalTo((Object)"Ana from BA")));
    }

    @Test
    @Description(value="Verifies that variables, attributes and errors are propagated forward, the established payload used and that the result payload is propagated back including it's type.")
    public void lookupDataIsPropagatedInBothDirections() throws Exception {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("key", "value");
        Message result = ((FlowRunner)((FlowRunner)((FlowRunner)this.flowRunner("fromErrorHandler").withPayload(payload)).withVariable("text", (Object)"some text", DataType.TEXT_STRING)).withAttributes((Object)new String[]{"first", "second"})).keepStreamsOpen().runAndVerify(new String[]{"propagation"}).getMessage();
        Assert.assertThat((Object)result, (Matcher)MessageMatchers.hasPayload((Matcher)Matchers.equalTo((Object)"Propagation was successful")));
        Assert.assertThat((Object)result.getPayload().getDataType().getMediaType().toRfcString(), (Matcher)Matchers.is((Object)"text/plain; charset=UTF-8"));
    }

    @Test
    public void lookupCallsFlowThatHandlesError() throws Exception {
        Assert.assertThat((Object)((FlowRunner)((FlowRunner)this.flowRunner("expressionParams").withVariable("flow", (Object)"failureHandledFlow")).withPayload((Object)"test")).keepStreamsOpen().run().getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)Matchers.equalTo((Object)"Flow failed but lets move on")));
    }

    @Test
    public void lookupFailsWhenCalledFlowThrowsError() throws Exception {
        this.expectedError.expectErrorType("MULE", "EXPRESSION");
        this.expectedError.expectCause(Matchers.isA(ExpressionRuntimeException.class));
        this.expectedError.expectMessage(Matchers.containsString((String)"Flow 'failingFlow' has failed with error 'MULE:UNKNOWN' (Functional Test Service Exception)"));
        ((FlowRunner)((FlowRunner)this.flowRunner("expressionParams").withVariable("flow", (Object)"failingFlow")).withPayload((Object)"test")).run();
    }

    @Test
    public void lookupFailsWhenCalledFlowTimesOut() throws Exception {
        this.expectedError.expectErrorType("MULE", "EXPRESSION");
        this.expectedError.expectCause(Matchers.isA(ExpressionRuntimeException.class));
        this.expectedError.expectMessage(Matchers.containsString((String)"Flow 'timeoutFlow' has timed out after 100 millis"));
        ((FlowRunner)((FlowRunner)this.flowRunner("expressionParamsWithTimeout").withVariable("flow", (Object)"timeoutFlow")).withPayload((Object)"test")).run();
    }

    @Test
    public void lookupCallsFlowThatHandlesConnectorError() throws Exception {
        Assert.assertThat((Object)((FlowRunner)this.flowRunner("staticParams").withVariable("status", (Object)401)).keepStreamsOpen().run().getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)Matchers.equalTo((Object)"Request was unauthorized but lets move on")));
    }

    @Test
    public void lookupFailsWhenCalledFlowThrowsConnectorError() throws Exception {
        this.expectedError.expectErrorType("MULE", "EXPRESSION");
        this.expectedError.expectCause(Matchers.isA(ExpressionRuntimeException.class));
        this.expectedError.expectMessage(Matchers.containsString((String)String.format("\"Exception while executing lookup(\"callApi\",\"data\",2000 as Number {class: \"java.lang.Integer\"}) cause: Flow 'callApi' has failed with error 'HTTP:METHOD_NOT_ALLOWED' (HTTP GET on resource 'http://localhost:%s/405' failed: method not allowed (405).) \n", this.port.getValue())));
        ((FlowRunner)this.flowRunner("staticParams").withVariable("status", (Object)405)).run();
    }

    @Test
    public void lookupFailsWhenFlowDoesNotExist() throws Exception {
        this.expectedError.expectErrorType("MULE", "EXPRESSION");
        this.expectedError.expectCause(Matchers.isA(ExpressionRuntimeException.class));
        this.expectedError.expectMessage(Matchers.containsString((String)"There is no component named 'non-existent'."));
        ((FlowRunner)((FlowRunner)this.flowRunner("expressionParams").withVariable("flow", (Object)"non-existent")).withPayload((Object)"test")).run();
    }

    @Test
    public void lookupFailsWhenReferenceIsNotAFlow() throws Exception {
        this.expectedError.expectErrorType("MULE", "EXPRESSION");
        this.expectedError.expectCause(Matchers.isA(ExpressionRuntimeException.class));
        this.expectedError.expectMessage(Matchers.containsString((String)"Component 'request-config' is not a flow."));
        ((FlowRunner)((FlowRunner)this.flowRunner("expressionParams").withVariable("flow", (Object)"request-config")).withPayload((Object)"test")).run();
    }

    @Test
    public void accessObjectsFromRegistryBinding() throws Exception {
        this.flowRunner("registryBindingFlow").run();
    }

    @Test
    public void checkCompatibleDataTypes() throws Exception {
        DataType compatible1 = DataType.builder().type(Parent.class).mediaType(MediaType.ANY).build();
        DataType compatible2 = DataType.builder().type(Child.class).mediaType(MediaType.APPLICATION_JAVA).build();
        DataType nonCompatible = DataType.STRING;
        ((FlowRunner)((FlowRunner)((FlowRunner)this.flowRunner("checkCompatibleDataTypes").withVariable("compatible1", (Object)compatible1)).withVariable("compatible2", (Object)compatible2)).withVariable("nonCompatible", (Object)nonCompatible)).run().getMessage();
    }

    @Test
    public void causedBySameType() throws Exception {
        Assert.assertThat((Object)this.flowRunner("sameType").run().getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)Matchers.equalTo((Object)"A connection failed.")));
    }

    @Test
    public void causedByParentType() throws Exception {
        Assert.assertThat((Object)this.flowRunner("subType").run().getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)Matchers.equalTo((Object)"A connection failed.")));
    }

    @Test
    public void causedByNonExistingType() throws Exception {
        this.expectedError.expectErrorType("MULE", "EXPRESSION");
        this.expectedError.expectMessage(Matchers.containsString((String)"Could not find error type 'ZARAZA'"));
        this.flowRunner("nonExistentType").run();
    }

    @Test
    public void causedByNullType() throws Exception {
        this.expectedError.expectErrorType("MULE", "EXPRESSION");
        this.expectedError.expectMessage(Matchers.containsString((String)"identifier cannot be an empty string or null"));
        this.flowRunner("nullType").run();
    }

    @Test
    public void causedByWithoutError() throws Exception {
        this.expectedError.expectErrorType("MULE", "EXPRESSION");
        this.expectedError.expectMessage(Matchers.containsString((String)"There's no error to match against"));
        this.flowRunner("noError").run();
    }

    public static String sleepForTimeoutTest() {
        try {
            Thread.sleep(10000L);
            return "Good Morning!";
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return "Rude Awakening";
        }
    }

    private static class Child
    extends Parent {
        private Child() {
        }
    }

    private static class Parent {
        private Parent() {
        }
    }
}

