/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="ObjectStore Extension")
@Story(value="ObjectStore is used as an operation parameter")
public class ExtensionWithObjectStoreTestCase
extends AbstractIntegrationTestCase {
    @Inject
    private ObjectStoreManager objectStoreManager;

    protected String getConfigFile() {
        return "extension-with-objectstore-config.xml";
    }

    @Test
    @Description(value="Operation has a parameter which points to a globally defined object store")
    public void storeOnGlobalStore() throws Exception {
        this.assertStoreValue("storeMoneyOnGlobalStore", "bank");
    }

    @Test
    @Description(value="Operation has a parameter which points to a private ObjectStore defined inline")
    public void storeOnPrivateStore() throws Exception {
        this.assertStoreValue("storeMoneyOnPrivateStore", "burriedBarrel");
    }

    private void assertStoreValue(String flowName, String osName) throws Exception {
        this.flowRunner(flowName).run();
        ObjectStore objectStore = this.objectStoreManager.getObjectStore(osName);
        Assert.assertThat((Object)objectStore.retrieve("money"), (Matcher)CoreMatchers.equalTo((Object)1234L));
    }
}

