/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transaction.TransactionCoordination;

public class ThreadCaptor
extends AbstractComponent
implements Processor,
Initialisable,
Disposable {
    private static Set<Thread> capturedThreads;
    private static AtomicInteger timeout;

    public void initialise() throws InitialisationException {
        ThreadCaptor.setCapturedThreads(ConcurrentHashMap.newKeySet());
        timeout = new AtomicInteger(0);
    }

    public void dispose() {
        ThreadCaptor.setCapturedThreads(null);
    }

    public CoreEvent process(CoreEvent event) throws MuleException {
        Latch latch;
        capturedThreads.add(Thread.currentThread());
        if (TransactionCoordination.isTransactionActive()) {
            timeout.set(TransactionCoordination.getInstance().getTransaction().getTimeout());
        }
        if (capturedThreads.size() > 2 && (latch = (Latch)((TypedValue)event.getVariables().get("latch")).getValue()) != null) {
            latch.release();
        }
        return event;
    }

    private static void setCapturedThreads(Set<Thread> capturedThreads) {
        ThreadCaptor.capturedThreads = capturedThreads;
    }

    public static Set<Thread> getCapturedThreads() {
        return capturedThreads;
    }

    public static int getLastTransactionTimeout() {
        return timeout.get();
    }
}

