/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInRelativeOrder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mule.functional.junit4.TestComponentBuildingDefinitionRegistryFactory;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.privileged.exception.TemplateOnErrorHandler;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tests.api.LifecycleTrackerRegistry;

@Feature(value="Error Handling")
@Story(value="Default Error Handler")
public class DefaultErrorHandlerLifecycleTestCase
extends AbstractIntegrationTestCase {
    @Inject
    private LifecycleTrackerRegistry trackersRegistry;
    @Inject
    @Named(value="flowD")
    private FlowConstruct flowD;
    @Inject
    @Named(value="flowE")
    private FlowConstruct flowE;
    @Inject
    @Named(value="flowF")
    private FlowConstruct flowF;
    private static TestComponentBuildingDefinitionRegistryFactory previous;

    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/default-error-handler-lifecycle.xml";
    }

    @BeforeClass
    public static void beforeClass() {
        TemplateOnErrorHandler.reuseGlobalErrorHandler = true;
        previous = componentBuildingDefinitionRegistryFactory;
        componentBuildingDefinitionRegistryFactory = new TestComponentBuildingDefinitionRegistryFactory();
        componentBuildingDefinitionRegistryFactory.setRefreshRuntimeComponentBuildingDefinitions(true);
    }

    @AfterClass
    public static void afterClass() {
        TemplateOnErrorHandler.reuseGlobalErrorHandler = null;
        componentBuildingDefinitionRegistryFactory = previous;
    }

    @Test
    public void testLifecycleDefaultErrorHandler() throws Exception {
        this.flowRunner(this.flowD.getName()).run();
        List defaultEhErrorHandlerPhases = this.trackersRegistry.get("defaultEhErrorHandlerTracker").getCalledPhases();
        Assert.assertThat((Object)defaultEhErrorHandlerPhases, (Matcher)IsIterableContainingInRelativeOrder.containsInRelativeOrder((Object[])new String[]{"initialise", "start"}));
        ((Lifecycle)this.flowD).stop();
        ((Lifecycle)this.flowE).stop();
        ((Lifecycle)this.flowD).dispose();
        ((Lifecycle)this.flowE).dispose();
        Assert.assertThat((Object)defaultEhErrorHandlerPhases, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)"stop")));
        Assert.assertThat((Object)defaultEhErrorHandlerPhases, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)"dispose")));
        ((Lifecycle)this.flowF).stop();
        ((Lifecycle)this.flowF).dispose();
        Assert.assertThat((Object)defaultEhErrorHandlerPhases, (Matcher)IsIterableContainingInRelativeOrder.containsInRelativeOrder((Object[])new String[]{"stop", "dispose"}));
    }
}

