/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transaction;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transaction.DelegateTransactionFactory;
import org.mule.runtime.core.api.transaction.MuleTransactionConfig;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class TransactionalTryTestCase
extends AbstractIntegrationTestCase {
    @Inject
    @Named(value="standardTry")
    private Flow standardTryFlow;
    private String config;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"Local Error Handler", "transactional-try-config.xml"}, {"Global Error Handler", "transactional-try-config-global-err.xml"});
    }

    public TransactionalTryTestCase(String type, String config) {
        this.config = config;
    }

    protected String getConfigFile() {
        return this.config;
    }

    @Test
    public void resolvesStandardTransactionFactory() throws Exception {
        Processor processor = (Processor)this.standardTryFlow.getProcessors().get(0);
        Assert.assertThat((Object)processor.getClass().getName(), (Matcher)Matchers.equalTo((Object)"org.mule.runtime.core.internal.processor.TryScope"));
        Method getTransactionConfigMethod = processor.getClass().getMethod("getTransactionConfig", new Class[0]);
        MuleTransactionConfig transactionConfig = (MuleTransactionConfig)getTransactionConfigMethod.invoke((Object)processor, new Object[0]);
        Assert.assertThat((Object)transactionConfig.getFactory(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DelegateTransactionFactory.class)));
        Assert.assertThat((Object)transactionConfig.getTimeout(), (Matcher)Matchers.is((Object)30000));
    }
}

