/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.interception;

import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.interception.InterceptionAction;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.heisenberg.extension.HeisenbergConnection;
import org.mule.test.heisenberg.extension.HeisenbergConnectionProvider;
import org.mule.test.integration.interception.ProcessorInterceptorFactoryTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Interception API")
@Story(value="Component Interception Story")
@RunnerDelegateTo(value=Parameterized.class)
public class ProcessorInterceptorFactoryCustomActionTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public ExpectedError expectedError = ExpectedError.none();
    private final boolean mutateEventBefore;
    @Rule
    public DynamicPort wireMockPort = new DynamicPort("wireMockPort");
    @Rule
    public WireMockRule wireMock = new WireMockRule((Options)WireMockConfiguration.wireMockConfig().bindAddress("127.0.0.1").port(this.wireMockPort.getNumber()));

    public ProcessorInterceptorFactoryCustomActionTestCase(boolean mutateEventBefore) {
        this.mutateEventBefore = mutateEventBefore;
    }

    @Parameterized.Parameters(name="mutateEventBefore: {0}")
    public static Collection<Object> data() {
        return Arrays.asList(true, false);
    }

    @Before
    public void setUp() {
        this.wireMock.stubFor(WireMock.get((UrlMatchingStrategy)WireMock.urlMatching((String)"/404")).willReturn(WireMock.aResponse().withStatus(404)));
        this.wireMock.stubFor(WireMock.get((UrlMatchingStrategy)WireMock.urlMatching((String)"/418")).willReturn(WireMock.aResponse().withStatus(418)));
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/interception/processor-interceptor-factory.xml";
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        objects.put("_CustomActionInterceptorFactory", new CustomActionInterceptorFactory());
        objects.put("_HasInjectedAttributesInterceptorFactory", new ProcessorInterceptorFactoryTestCase.HasInjectedAttributesInterceptorFactory(this.mutateEventBefore));
        objects.put("_muleProcessorInterceptorFactoryOrder", () -> Arrays.asList(CustomActionInterceptorFactory.class.getName(), ProcessorInterceptorFactoryTestCase.HasInjectedAttributesInterceptorFactory.class.getName()));
        return objects;
    }

    @Before
    public void before() {
        CustomActionInterceptor.actioner = action -> action.proceed();
    }

    @After
    public void after() {
        HeisenbergConnectionProvider.getActiveConnections().clear();
        ProcessorInterceptorFactoryTestCase.HasInjectedAttributesInterceptor.interceptionParameters.clear();
    }

    @Test
    @Description(value="The connection was fetched on the interceptor, and released by the interceptor")
    public void resolvedConnectionParamSkips() throws Exception {
        int connectsBefore = HeisenbergConnectionProvider.getConnects();
        int disconnectsBefore = HeisenbergConnectionProvider.getDisconnects();
        CustomActionInterceptor.actioner = action -> action.skip();
        this.flowRunner("callSaul").run();
        List<ProcessorInterceptorFactoryTestCase.InterceptionParameters> interceptionParameters = ProcessorInterceptorFactoryTestCase.HasInjectedAttributesInterceptor.interceptionParameters;
        Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)1));
        ProcessorInterceptorFactoryTestCase.InterceptionParameters killInterceptionParameter = interceptionParameters.get(0);
        Assert.assertThat(killInterceptionParameter.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"targetValue", "config-ref", "connection"}));
        Assert.assertThat((Object)killInterceptionParameter.getParameters().get("config-ref").resolveValue(), (Matcher)Matchers.is((Object)"heisenberg"));
        Assert.assertThat((Object)killInterceptionParameter.getParameters().get("connection").resolveValue(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(HeisenbergConnection.class)));
        Assert.assertThat((Object)HeisenbergConnectionProvider.getActiveConnections(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)(HeisenbergConnectionProvider.getConnects() - connectsBefore), (Matcher)Matchers.is((Object)(this.mutateEventBefore ? 2 : 1)));
        Assert.assertThat((Object)(HeisenbergConnectionProvider.getDisconnects() - disconnectsBefore), (Matcher)Matchers.is((Object)(this.mutateEventBefore ? 2 : 1)));
    }

    @Test
    @Description(value="The params are solved, when a tracing operation is used.")
    @Issue(value="W-14773408")
    public void resolvedParamsForTracingOperation() throws Exception {
        this.flowRunner("tracing").run();
        List<ProcessorInterceptorFactoryTestCase.InterceptionParameters> interceptionParameters = ProcessorInterceptorFactoryTestCase.HasInjectedAttributesInterceptor.interceptionParameters;
        Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(interceptionParameters.get(0).getParameters(), (Matcher)Matchers.hasKey((Object)"variableName"));
        Assert.assertThat(interceptionParameters.get(0).getParameters(), (Matcher)Matchers.hasKey((Object)"value"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="The connection was fetched on the interceptor, and released by the interceptor")
    public void resolvedConnectionParamFails() throws Exception {
        List<ProcessorInterceptorFactoryTestCase.InterceptionParameters> interceptionParameters2;
        int connectsBefore = HeisenbergConnectionProvider.getConnects();
        int disconnectsBefore = HeisenbergConnectionProvider.getDisconnects();
        CustomActionInterceptor.actioner = action -> action.fail((Throwable)new RuntimeException());
        try {
            this.flowRunner("callSaul").run();
            Assert.fail((String)"Expected an exception. Refer to ReactiveInterceptorAdapterTestCase");
            interceptionParameters2 = ProcessorInterceptorFactoryTestCase.HasInjectedAttributesInterceptor.interceptionParameters;
        }
        catch (Exception interceptionParameters2) {
            List<ProcessorInterceptorFactoryTestCase.InterceptionParameters> interceptionParameters3 = ProcessorInterceptorFactoryTestCase.HasInjectedAttributesInterceptor.interceptionParameters;
            Assert.assertThat(interceptionParameters3, (Matcher)Matchers.hasSize((int)2));
            ProcessorInterceptorFactoryTestCase.InterceptionParameters killInterceptionParameter = interceptionParameters3.get(0);
            Assert.assertThat(killInterceptionParameter.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"targetValue", "config-ref", "connection"}));
            Assert.assertThat((Object)killInterceptionParameter.getParameters().get("config-ref").resolveValue(), (Matcher)Matchers.is((Object)"heisenberg"));
            Assert.assertThat((Object)killInterceptionParameter.getParameters().get("connection").resolveValue(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(HeisenbergConnection.class)));
            Assert.assertThat((Object)HeisenbergConnectionProvider.getActiveConnections(), (Matcher)Matchers.empty());
            Assert.assertThat((Object)(HeisenbergConnectionProvider.getConnects() - connectsBefore), (Matcher)Matchers.is((Object)(this.mutateEventBefore ? 2 : 1)));
            Assert.assertThat((Object)(HeisenbergConnectionProvider.getDisconnects() - disconnectsBefore), (Matcher)Matchers.is((Object)(this.mutateEventBefore ? 2 : 1)));
        }
        catch (Throwable throwable) {
            List<ProcessorInterceptorFactoryTestCase.InterceptionParameters> interceptionParameters4 = ProcessorInterceptorFactoryTestCase.HasInjectedAttributesInterceptor.interceptionParameters;
            Assert.assertThat(interceptionParameters4, (Matcher)Matchers.hasSize((int)2));
            ProcessorInterceptorFactoryTestCase.InterceptionParameters killInterceptionParameter = interceptionParameters4.get(0);
            Assert.assertThat(killInterceptionParameter.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"targetValue", "config-ref", "connection"}));
            Assert.assertThat((Object)killInterceptionParameter.getParameters().get("config-ref").resolveValue(), (Matcher)Matchers.is((Object)"heisenberg"));
            Assert.assertThat((Object)killInterceptionParameter.getParameters().get("connection").resolveValue(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(HeisenbergConnection.class)));
            Assert.assertThat((Object)HeisenbergConnectionProvider.getActiveConnections(), (Matcher)Matchers.empty());
            Assert.assertThat((Object)(HeisenbergConnectionProvider.getConnects() - connectsBefore), (Matcher)Matchers.is((Object)(this.mutateEventBefore ? 2 : 1)));
            Assert.assertThat((Object)(HeisenbergConnectionProvider.getDisconnects() - disconnectsBefore), (Matcher)Matchers.is((Object)(this.mutateEventBefore ? 2 : 1)));
            throw throwable;
        }
        Assert.assertThat(interceptionParameters2, (Matcher)Matchers.hasSize((int)2));
        ProcessorInterceptorFactoryTestCase.InterceptionParameters killInterceptionParameter = interceptionParameters2.get(0);
        Assert.assertThat(killInterceptionParameter.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"targetValue", "config-ref", "connection"}));
        Assert.assertThat((Object)killInterceptionParameter.getParameters().get("config-ref").resolveValue(), (Matcher)Matchers.is((Object)"heisenberg"));
        Assert.assertThat((Object)killInterceptionParameter.getParameters().get("connection").resolveValue(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(HeisenbergConnection.class)));
        Assert.assertThat((Object)HeisenbergConnectionProvider.getActiveConnections(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)(HeisenbergConnectionProvider.getConnects() - connectsBefore), (Matcher)Matchers.is((Object)(this.mutateEventBefore ? 2 : 1)));
        Assert.assertThat((Object)(HeisenbergConnectionProvider.getDisconnects() - disconnectsBefore), (Matcher)Matchers.is((Object)(this.mutateEventBefore ? 2 : 1)));
    }

    @Test
    @Description(value="The connection was fetched on the interceptor, and the operation uses the connection obtained there rather then fetching it again")
    public void resolvedConnectionParam() throws Exception {
        int connectsBefore = HeisenbergConnectionProvider.getConnects();
        int disconnectsBefore = HeisenbergConnectionProvider.getDisconnects();
        this.flowRunner("callSaul").run();
        List<ProcessorInterceptorFactoryTestCase.InterceptionParameters> interceptionParameters = ProcessorInterceptorFactoryTestCase.HasInjectedAttributesInterceptor.interceptionParameters;
        Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)1));
        ProcessorInterceptorFactoryTestCase.InterceptionParameters killInterceptionParameter = interceptionParameters.get(0);
        Assert.assertThat(killInterceptionParameter.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"targetValue", "config-ref", "connection"}));
        Assert.assertThat((Object)killInterceptionParameter.getParameters().get("config-ref").resolveValue(), (Matcher)Matchers.is((Object)"heisenberg"));
        Assert.assertThat((Object)killInterceptionParameter.getParameters().get("connection").resolveValue(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(HeisenbergConnection.class)));
        Assert.assertThat((Object)HeisenbergConnectionProvider.getActiveConnections(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)(HeisenbergConnectionProvider.getConnects() - connectsBefore), (Matcher)Matchers.is((Object)(this.mutateEventBefore ? 2 : 1)));
        Assert.assertThat((Object)(HeisenbergConnectionProvider.getDisconnects() - disconnectsBefore), (Matcher)Matchers.is((Object)(this.mutateEventBefore ? 2 : 1)));
    }

    @Test
    @Issue(value="MULE-19245")
    public void operationWithDeferredStreamParam() throws Exception {
        Assume.assumeThat((Object)this.mutateEventBefore, (Matcher)Matchers.is((Object)false));
        CoreEvent result = this.flowRunner("operationWithDeferredStreamParam").run();
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)"Knocked on Jim Malone"));
    }

    public static class CustomActionInterceptor
    implements ProcessorInterceptor {
        private static Function<InterceptionAction, CompletableFuture<InterceptionEvent>> actioner = action -> action.proceed();

        public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
            return actioner.apply(action);
        }
    }

    public static class CustomActionInterceptorFactory
    implements ProcessorInterceptorFactory {
        public ProcessorInterceptor get() {
            return new CustomActionInterceptor();
        }
    }
}

