/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.component.EventCallback;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class ErrorHandlerWorksWithTxTestCase
extends AbstractIntegrationTestCase {
    private static final String ERROR_HANDLER_REF = "errorHandlerName";
    private static ThreadLocal<Boolean> execution = new ThreadLocal();
    private static Boolean executedInSameThread;
    private final String config;
    @Rule
    public SystemProperty property;

    @Parameterized.Parameters(name="{0} - {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"Local Error Handler", "org/mule/test/integration/exceptions/error-handler-tx-same-thread.xml", "errorHandlerWithTestNonBlocking"}, {"Local Error Handler", "org/mule/test/integration/exceptions/error-handler-tx-same-thread.xml", "errorHandlerWithProcessingTypeChange"}, {"Local Error Handler", "org/mule/test/integration/exceptions/error-handler-tx-same-thread.xml", "errorHandlerWithNonBlockingOp"}, {"Local Error Handler", "org/mule/test/integration/exceptions/error-handler-tx-same-thread.xml", "errorHandlerWithNonBlockingOpAndProcessingTypeChange"}, {"Global Error Handler", "org/mule/test/integration/exceptions/error-handler-tx-same-thread-global-err.xml", "errorHandlerWithTestNonBlocking"}, {"Global Error Handler", "org/mule/test/integration/exceptions/error-handler-tx-same-thread-global-err.xml", "errorHandlerWithProcessingTypeChange"}, {"Global Error Handler", "org/mule/test/integration/exceptions/error-handler-tx-same-thread-global-err.xml", "errorHandlerWithNonBlockingOp"}, {"Global Error Handler", "org/mule/test/integration/exceptions/error-handler-tx-same-thread-global-err.xml", "errorHandlerWithNonBlockingOpAndProcessingTypeChange"});
    }

    protected String getConfigFile() {
        return this.config;
    }

    public ErrorHandlerWorksWithTxTestCase(String type, String config, String errorHandlerName) {
        this.property = new SystemProperty(ERROR_HANDLER_REF, errorHandlerName);
        this.config = config;
    }

    @After
    public void tearDown() {
        execution.remove();
        executedInSameThread = false;
    }

    @Test
    public void doesNotChangeThread() throws Exception {
        CoreEvent event = this.flowRunner("flowWithTx").run();
        Assert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"zaraza"));
        Assert.assertThat((Object)executedInSameThread, (Matcher)CoreMatchers.is((Object)true));
    }

    public static class FinishProcess
    extends AbstractComponent
    implements EventCallback {
        public void eventReceived(CoreEvent event, Object component, MuleContext muleContext) throws Exception {
            if (((Boolean)execution.get()).booleanValue()) {
                executedInSameThread = true;
            }
        }
    }

    public static class StartProcess
    extends AbstractComponent
    implements EventCallback {
        public void eventReceived(CoreEvent event, Object component, MuleContext muleContext) throws Exception {
            execution.set(true);
        }
    }
}

