/*
 * Decompiled with CFR 0.152.
 */
package org.mule.shutdown;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.junit4.DomainFunctionalTestCase;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.report.HeapDumpOnFailure;

@Ignore(value="MULE-10335")
@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Graceful shutdown")
public class ShutdownAppInDomainTestCase
extends DomainFunctionalTestCase {
    private static final int PROBER_POLLING_INTERVAL = 100;
    private static final int PROBER_POLIING_TIMEOUT = 5000;
    private static final int MESSAGE_TIMEOUT = 2000;
    @Rule
    public HeapDumpOnFailure heapDumpOnFailure = new HeapDumpOnFailure();
    private static final Set<PhantomReference<CoreEvent>> requestContextRefs = new HashSet<PhantomReference<CoreEvent>>();
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder().build();
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");

    @Before
    public void before() {
        requestContextRefs.clear();
    }

    protected String getDomainConfig() {
        return "org/mule/shutdown/domain-with-connectors.xml";
    }

    public DomainFunctionalTestCase.ApplicationConfig[] getConfigResources() {
        return new DomainFunctionalTestCase.ApplicationConfig[]{new DomainFunctionalTestCase.ApplicationConfig("app-with-flows", new String[]{"org/mule/shutdown/app-with-flows.xml"})};
    }

    @Test
    public void httpListener() throws IOException, TimeoutException {
        MuleContext muleContextForApp = this.getMuleContextForApp("app-with-flows");
        HttpRequest request = HttpRequest.builder().uri("http://localhost:" + this.httpPort.getNumber() + "/sync").method(HttpConstants.Method.GET).build();
        this.httpClient.send(request, 2000, false, null);
        muleContextForApp.dispose();
        this.assertEventsUnreferenced();
    }

    @Test
    public void httpListenerNonBlocking() throws IOException, TimeoutException {
        MuleContext muleContextForApp = this.getMuleContextForApp("app-with-flows");
        HttpRequest request = HttpRequest.builder().uri("http://localhost:" + this.httpPort.getNumber() + "/nonBlocking").method(HttpConstants.Method.GET).build();
        this.httpClient.send(request, 2000, false, null);
        muleContextForApp.dispose();
        this.assertEventsUnreferenced();
    }

    @Test
    public void httpRequest() throws IOException, TimeoutException {
        MuleContext muleContextForApp = this.getMuleContextForApp("app-with-flows");
        HttpRequest request = HttpRequest.builder().uri("http://localhost:" + this.httpPort.getNumber() + "/request").method(HttpConstants.Method.GET).build();
        this.httpClient.send(request, 2000, false, null);
        muleContextForApp.dispose();
        this.assertEventsUnreferenced();
    }

    @Test
    @Ignore(value="Reimplement with the new JMS Connector")
    public void jms() throws MuleException {
        MuleContext muleContextForApp = this.getMuleContextForApp("app-with-flows");
        muleContextForApp.dispose();
        this.assertEventsUnreferenced();
    }

    private void assertEventsUnreferenced() {
        new PollingProber(5000L, 100L).check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                System.gc();
                for (PhantomReference phantomReference : requestContextRefs) {
                    Assert.assertThat((Object)phantomReference.isEnqueued(), (Matcher)CoreMatchers.is((Object)true));
                }
                return true;
            }
        });
    }

    public static class RetrieveRequestContext
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            requestContextRefs.add(new PhantomReference<PrivilegedEvent>(PrivilegedEvent.getCurrentEvent(), new ReferenceQueue()));
            return event;
        }
    }
}

