/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.usecases.routing.response;

import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.SimpleMemoryObjectStore;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;

public class SerializationOnResponseAggregatorTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder((HttpService)this.getService(HttpService.class)).build();

    protected String getConfigFile() {
        return "org/mule/test/usecases/routing/response/serialization-on-response-router-config.xml";
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        HashMap<String, Object> registryObjects = new HashMap<String, Object>();
        registryObjects.put("_defaultInMemoryObjectStore", (Object)new TestObjectStore());
        return registryObjects;
    }

    @Test
    public void testSyncResponse() throws Exception {
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri("http://localhost:" + this.dynamicPort.getNumber()).entity((HttpEntity)new ByteArrayHttpEntity("request".getBytes()))).method(HttpConstants.Method.POST).build();
        HttpResponse response = this.httpClient.send(request, 5000, false, null);
        String payload = IOUtils.toString((InputStream)response.getEntity().getContent());
        Assert.assertThat((Object)payload, (Matcher)CoreMatchers.is((Object)"request processed"));
    }

    private static class TestObjectStore
    extends SimpleMemoryObjectStore<Serializable> {
        @Inject
        private ObjectSerializer serializer;

        private TestObjectStore() {
        }

        protected void doStore(String key, Serializable value) throws ObjectStoreException {
            byte[] serialized = this.serializer.getExternalProtocol().serialize((Object)value);
            super.doStore(key, (Serializable)serialized);
        }

        protected Serializable doRetrieve(String key) throws ObjectStoreException {
            Serializable serialized = super.doRetrieve(key);
            return (Serializable)this.serializer.getExternalProtocol().deserialize((byte[])serialized);
        }
    }
}

