/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.interception;

import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Interception API")
@Story(value="Component Interception Story")
public class ProcessorInterceptorFactoryFailingInterceptorsTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public ExpectedError expectedError = ExpectedError.none();
    @Rule
    public DynamicPort wireMockPort = new DynamicPort("wireMockPort");
    @Rule
    public WireMockRule wireMock = new WireMockRule((Options)WireMockConfiguration.wireMockConfig().bindAddress("127.0.0.1").port(this.wireMockPort.getNumber()));
    private static RuntimeException THROWN = new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Expected exception in after()"));
    private final AtomicBoolean afterCallbackCalledForFailingMP = new AtomicBoolean(false);

    @Before
    public void setUp() {
        this.wireMock.stubFor(WireMock.get((UrlMatchingStrategy)WireMock.urlMatching((String)"/404")).willReturn(WireMock.aResponse().withStatus(404)));
        this.wireMock.stubFor(WireMock.get((UrlMatchingStrategy)WireMock.urlMatching((String)"/418")).willReturn(WireMock.aResponse().withStatus(418)));
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/interception/processor-interceptor-factory.xml";
    }

    @Before
    public void before() {
        this.expectedError.expectErrorType("MULE", "UNKNOWN").expectCause(Matchers.sameInstance((Object)THROWN));
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        objects.put("_FailingAfterInterceptorFactory", new FailingAfterInterceptorFactory());
        objects.put("_muleProcessorInterceptorFactoryOrder", () -> Arrays.asList(FailingAfterInterceptorFactory.class.getName()));
        return objects;
    }

    @Test
    public void operationParameters() throws Exception {
        ((FlowRunner)((FlowRunner)this.flowRunner("killFromPayload").withPayload((Object)"T-1000")).withVariable("goodbye", (Object)"Hasta la vista, baby")).run();
    }

    @Test
    public void resolvedConfigOperationParameters() throws Exception {
        this.flowRunner("die").run();
    }

    @Test
    public void resolvedComplexParametersOperationParameters() throws Exception {
        ((FlowRunner)this.flowRunner("killWithCustomMessage").withVariable("goodbye", (Object)"Hasta la vista, baby")).run();
    }

    @Test
    @Description(value="The errorType set by an operation is preserved if an interceptor is applied")
    public void failingOperationErrorTypePreserved() throws Exception {
        this.expectedError.expectErrorType("TEST", "EXPECTED").expectCause(Matchers.sameInstance((Object)THROWN));
        this.expectedError.expectErrorType("HEISENBERG", "CONNECTIVITY").expectCause(Matchers.sameInstance((Object)THROWN));
        this.flowRunner("callGusFring").run();
    }

    @Test
    @Description(value="Errors in sub-flows are handled correctly")
    public void failingSubFlow() throws Exception {
        this.expectedError.expectErrorType("TEST", "EXPECTED").expectCause(Matchers.sameInstance((Object)THROWN));
        this.flowRunner("flowWithFailingSubFlowRef").run();
    }

    @Test
    @Description(value="Processors in error handlers are intercepted correctly")
    public void errorHandler() throws Exception {
        this.expectedError.expectErrorType("TEST", "EXPECTED").expectCause(Matchers.sameInstance((Object)THROWN));
        this.flowRunner("flowFailingWithErrorHandler").run();
    }

    @Test
    @Description(value="Processors in global error handlers are intercepted correctly")
    public void globalErrorHandler() throws Exception {
        this.expectedError.expectErrorType("TEST", "EXPECTED").expectCause(Matchers.sameInstance((Object)THROWN));
        this.flowRunner("flowFailing").run();
    }

    @Test
    @Description(value="Processors in global error handlers are intercepted correctly when raise-error is used")
    public void globalErrorHandlerRaise() throws Exception {
        this.expectedError.expectErrorType("MULE", "CONNECTIVITY");
        this.flowRunner("flowRaise").run();
    }

    @Test
    @Description(value="Processors in global error handlers are intercepted correctly for errors in operations")
    public void globalErrorHandlerOperation() throws Exception {
        this.expectedError.expectErrorType("HEISENBERG", "HEALTH");
        this.flowRunner("flowFailingOperation").run();
    }

    @Test
    @Description(value="Processors in global error handlers are intercepted correctly for errors in operations")
    public void globalErrorHandlerOperationFromFlowRef() throws Exception {
        this.expectedError.expectErrorType("HEISENBERG", "HEALTH");
        this.flowRunner("flowFailingOperationFlowRef").run();
    }

    @Test
    @Description(value="Processors in global error handlers are intercepted correctly for an unknown status code errors in http request")
    public void globalErrorHandlerUnknownStatusCodeHttpRequest() throws Exception {
        this.flowRunner("flowUnknownStatusCodeHttpRequest").run();
    }

    @Test
    @Description(value="Processors in global error handlers are intercepted correctly when error is in referenced flow")
    public void globalErrorHandlerWithFlowRef() throws Exception {
        this.expectedError.expectErrorType("TEST", "EXPECTED").expectCause(Matchers.sameInstance((Object)THROWN));
        this.flowRunner("flowWithFailingFlowRef").run();
    }

    protected boolean isGracefulShutdown() {
        return true;
    }

    public class FailingAfterInterceptor
    implements ProcessorInterceptor {
        public void after(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
            if (!ProcessorInterceptorFactoryFailingInterceptorsTestCase.this.afterCallbackCalledForFailingMP.getAndSet(true)) {
                throw THROWN;
            }
        }
    }

    public class FailingAfterInterceptorFactory
    implements ProcessorInterceptorFactory {
        public ProcessorInterceptor get() {
            return new FailingAfterInterceptor();
        }
    }
}

