/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.api.component.EventCallback;
import org.mule.functional.api.exception.FunctionalTestException;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.test.AbstractIntegrationTestCase;

public class ExceptionPropagationMule5737TestCase
extends AbstractIntegrationTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/exception-propagation-mule-5737-config.xml";
    }

    @Before
    public void before() {
        SensingExceptionParentCallback.caught = false;
        SensingExceptionChildCallback.caught = true;
    }

    @Test
    public void testRequestResponseEndpointExceptionPropagation() throws Exception {
        this.expectedException.expectCause(Matchers.instanceOf(FunctionalTestException.class));
        this.runFlow("flow");
    }

    @Test
    public void testFlowWithChildFlowExceptionPropagation() throws Exception {
        this.runFlow("flowWithChildFlow");
        Assert.assertThat((Object)SensingExceptionParentCallback.caught, (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)SensingExceptionChildCallback.caught, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testFlowWithSubFlowExceptionPropagation() throws Exception {
        this.runFlow("flowWithSubFlow");
        Assert.assertThat((Object)SensingExceptionParentCallback.caught, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testFlowWithChildServiceExceptionPropagation() throws Exception {
        this.runFlow("flowWithChildService");
        Assert.assertThat((Object)SensingExceptionParentCallback.caught, (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)SensingExceptionChildCallback.caught, (Matcher)Matchers.is((Object)true));
    }

    public static class SensingExceptionChildCallback
    extends AbstractComponent
    implements EventCallback {
        static boolean caught;

        public void eventReceived(CoreEvent event, Object component, MuleContext muleContext) throws Exception {
            caught = true;
        }
    }

    public static class SensingExceptionParentCallback
    extends AbstractComponent
    implements EventCallback {
        static boolean caught;

        public void eventReceived(CoreEvent event, Object component, MuleContext muleContext) throws Exception {
            caught = true;
        }
    }
}

