/*
 * Decompiled with CFR 0.152.
 */
package org.mule.shutdown;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpVersion;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.AbstractIntegrationTestCase;

@Issue(value="MULE-18396")
@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Graceful shutdown")
public class HTTPPersistentConnectionsOnShutdownTestCase
extends AbstractIntegrationTestCase {
    private static final int SMALL_TIMEOUT_MILLIS = 300;
    private static final int POLL_DELAY_MILLIS = 50;
    private static final String SLOW_PROCESSING_ENDPOINT = "/slow";
    private static final String FAST_PROCESSING_ENDPOINT = "/fast";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("listener.port");
    private ExecutorService executor;

    protected String getConfigFile() {
        return "org/mule/shutdown/http-persistent-connections-on-shutdown.xml";
    }

    protected boolean isGracefulShutdown() {
        return true;
    }

    @Before
    public void setup() {
        this.executor = Executors.newSingleThreadExecutor();
    }

    @After
    public void tearDown() throws MuleException, InterruptedException {
        this.executor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        this.executor.shutdownNow();
        if (muleContext.isStopped()) {
            muleContext.start();
        }
    }

    @Test
    public void requestInflightDuringShutdownIsRespondedIncludingConnectionCloseHeader() throws IOException {
        try (Socket slowRequestConnection = new Socket("localhost", this.dynamicPort.getNumber());){
            this.sendRequest(slowRequestConnection, SLOW_PROCESSING_ENDPOINT);
            this.executor.submit(() -> {
                try {
                    muleContext.stop();
                }
                catch (MuleException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            });
            this.assertContextIsStopping(300L);
            String slowRequestResponse = this.getResponse(slowRequestConnection);
            this.assertResponse(slowRequestResponse, true);
            MatcherAssert.assertThat((Object)slowRequestResponse, (Matcher)CoreMatchers.containsString((String)"Connection: close"));
            this.sendRequest(slowRequestConnection, FAST_PROCESSING_ENDPOINT);
            slowRequestResponse = this.getResponse(slowRequestConnection);
            this.assertResponse(slowRequestResponse, false);
        }
    }

    @Test
    public void serverIsStoppedWhenPersistentConnectionsAreClosed() throws IOException {
        try (Socket idlePersistentConnection = this.generateIdlePersistentConnection();){
            this.executor.submit(() -> {
                try {
                    muleContext.stop();
                }
                catch (MuleException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            });
            this.assertContextIsStopping(300L);
            MatcherAssert.assertThat((Object)muleContext.isStopped(), (Matcher)Matchers.is((Object)false));
            idlePersistentConnection.close();
            this.assertContextHasStopped(300L);
        }
    }

    @Test
    public void onlyOneRequestIsValidUsingAnOldPersistentDuringShutdown() throws IOException, InterruptedException {
        Socket persistentConnection1 = this.generateIdlePersistentConnection();
        Socket persistentConnection2 = this.generateIdlePersistentConnection();
        Socket persistentConnection3 = this.generateIdlePersistentConnection();
        this.executor.submit(() -> {
            try {
                muleContext.stop();
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        });
        this.assertContextIsStopping(300L);
        this.sendRequest(persistentConnection1, FAST_PROCESSING_ENDPOINT);
        this.sendRequest(persistentConnection2, FAST_PROCESSING_ENDPOINT);
        String response1 = this.getResponse(persistentConnection1);
        String response2 = this.getResponse(persistentConnection2);
        this.assertResponse(response1, true);
        this.assertResponse(response2, true);
        MatcherAssert.assertThat((Object)response1, (Matcher)CoreMatchers.containsString((String)"Connection: close"));
        MatcherAssert.assertThat((Object)response2, (Matcher)CoreMatchers.containsString((String)"Connection: close"));
        Thread.sleep(50L);
        MatcherAssert.assertThat((Object)muleContext.isStopped(), (Matcher)Matchers.is((Object)false));
        this.sendRequest(persistentConnection1, FAST_PROCESSING_ENDPOINT);
        this.sendRequest(persistentConnection2, FAST_PROCESSING_ENDPOINT);
        this.assertResponse(this.getResponse(persistentConnection1), false);
        this.assertResponse(this.getResponse(persistentConnection2), false);
        Thread.sleep(50L);
        MatcherAssert.assertThat((Object)muleContext.isStopped(), (Matcher)Matchers.is((Object)false));
        persistentConnection3.close();
        this.assertContextHasStopped(300L);
    }

    private void assertContextIsStopping(long timeout) {
        new PollingProber(timeout, 50L).check(new Probe(){

            public boolean isSatisfied() {
                return muleContext.isStopping();
            }

            public String describeFailure() {
                return "Timeout waiting for muleContext to be in stopping state";
            }
        });
    }

    private void assertContextHasStopped(long timeout) {
        new PollingProber(timeout, 50L).check(new Probe(){

            public boolean isSatisfied() {
                return muleContext.isStopped();
            }

            public String describeFailure() {
                return "Timeout waiting for muleContext to be in stopped state";
            }
        });
    }

    private Socket generateIdlePersistentConnection() throws IOException {
        Socket socket = new Socket("localhost", this.dynamicPort.getNumber());
        MatcherAssert.assertThat((Object)socket.isConnected(), (Matcher)Matchers.is((Object)true));
        this.sendRequest(socket, FAST_PROCESSING_ENDPOINT);
        this.assertResponse(this.getResponse(socket), true);
        this.sendRequest(socket, FAST_PROCESSING_ENDPOINT);
        this.assertResponse(this.getResponse(socket), true);
        return socket;
    }

    private void sendRequest(Socket socket, String endpoint) throws IOException {
        PrintWriter writer = new PrintWriter(socket.getOutputStream());
        writer.println(String.format("GET %s %s", endpoint, HttpVersion.HTTP_1_1));
        writer.println("Host: www.example.com");
        writer.println("");
        writer.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getResponse(Socket socket) {
        try (StringWriter writer = new StringWriter();){
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while (!StringUtils.isEmpty((String)(line = reader.readLine()))) {
                writer.append(line).append("\r\n");
            }
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    private void assertResponse(String response, boolean shouldBeValid) {
        MatcherAssert.assertThat((Object)(!StringUtils.isEmpty((String)response) ? 1 : 0), (Matcher)Matchers.is((Object)shouldBeValid));
        if (shouldBeValid) {
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"HTTP/1.1 200"));
        }
    }
}

