/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.locator;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.core.context.notification.processors.ProcessorNotificationStore;

@Features(value={@Feature(value="Lazy Initialization"), @Feature(value="Configuration component locator")})
@Story(value="Search configuration")
public class LazyInitConfigurationComponentLocatorTestCase
extends AbstractIntegrationTestCase {
    private static final String MY_SUB_FLOW = "mySubFlow";
    private static final String FLOW_WITH_SUBFLOW = "flowWithSubflow";
    @Rule
    public DynamicPort listenPort = new DynamicPort("http.listener.port");
    @Rule
    public DynamicPort proxyPort = new DynamicPort("http.proxy.port");
    @Rule
    public SystemProperty path = new SystemProperty("path", "path");
    private static final int TOTAL_NUMBER_OF_LOCATIONS = 98;
    @Inject
    private Registry registry;
    @Inject
    private LazyComponentInitializer lazyComponentInitializer;

    protected String[] getConfigFiles() {
        return new String[]{"org/mule/test/integration/locator/component-locator-config.xml", "org/mule/test/integration/locator/component-locator-notifications.xml", "org/mule/test/integration/locator/component-locator-levels-config.xml", "org/mule/test/integration/locator/component-locator-os-connector.xml", "org/mule/test/integration/locator/component-locator-reference-component-models.xml"};
    }

    public boolean enableLazyInit() {
        return true;
    }

    public boolean disableXmlValidations() {
        return true;
    }

    @Description(value="Lazy init should not create components until an operation is done")
    @Test
    public void lazyInitCalculatesLocations() {
        List allLocations = this.locator.findAllLocations().stream().map(ComponentLocation::getLocation).collect(Collectors.toList());
        Assert.assertThat((String)allLocations.toString(), allLocations, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"myFlow", "myFlow/source", "myFlow/source/0/0", "myFlow/processors/0", "myFlow/processors/1", "myFlow/processors/2", "myFlow/processors/2/processors/0", "myFlow/processors/2/processors/1", "anotherFlow", "anotherFlow/source", "anotherFlow/source/0/0", "anotherFlow/processors/0", FLOW_WITH_SUBFLOW, "flowWithSubflow/processors/0", MY_SUB_FLOW, "mySubFlow/processors/0", "_muleConfiguration", "globalErrorHandler", "globalErrorHandler/0", "globalErrorHandler/0/processors/0", "flowFailing", "flowFailing/processors/0", "flowLvl0", "flowLvl0/processors/0", "flowLvl1", "flowLvl1/processors/0", "flowLvl2", "flowLvl2/processors/0", "flowLvl2/processors/1", "flowRecursive", "flowRecursive/processors/0", "dbConfig", "dbConfig/connection", "requestConfig", "requestConfig/connection", "tlsContextRef", "tlsContextRef/0", "anonymousProxyConfig", "globalObjectStore", "globalObjectStoreAggregatorFlow", "globalObjectStoreAggregatorFlow/processors/0", "globalObjectStoreAggregatorFlow/processors/0/route/0", "globalObjectStoreAggregatorFlow/processors/0/route/0/processors/0", "aggregatorWithMaxSizeFlow", "aggregatorWithMaxSizeFlow/processors/0", "aggregatorWithMaxSizeFlow/processors/1", "aggregatorWithMaxSizeListenerFlow", "aggregatorWithMaxSizeListenerFlow/source", "aggregatorWithMaxSizeListenerFlow/processors/0", "aggregatorOnListenerFlow", "aggregatorOnListenerFlow/processors/0", "justAnotherFlowThatShouldNotBeInitialized", "justAnotherFlowThatShouldNotBeInitialized/processors/0", "Matcher", "fileListWithMatcherReference", "fileListWithMatcherReference/source", "fileListWithMatcherReference/source/0/0", "fileListWithMatcherReference/processors/0", "listenerConfigRedeliveryPolicy", "listenerConfigRedeliveryPolicy/connection", "redeliveryPolicyFlow", "redeliveryPolicyFlow/source", "redeliveryPolicyFlow/source/0", "redeliveryPolicyFlow/processors/0", "redeliveryPolicyWithObjectStoreFlow", "redeliveryPolicyWithObjectStoreFlow/source", "redeliveryPolicyWithObjectStoreFlow/source/0", "redeliveryPolicyWithObjectStoreFlow/processors/0", "redeliveryPolicyFlowRef1", "redeliveryPolicyFlowRef1/processors/0", "redeliveryPolicyFlowRef2", "redeliveryPolicyFlowRef2/processors/0", "untilSuccessfulFlow", "untilSuccessfulFlow/processors/0", "untilSuccessfulFlow/processors/0/processors/0", "untilSuccessfulFlowCopy", "untilSuccessfulFlowCopy/processors/0", "untilSuccessfulFlowCopy/processors/0/processors/0", "multipleInitialize", "multipleInitialize/processors/0", "multipleInitialize/processors/1", "async-flow", "async-flow/processors/0", "async-flow/processors/0/processors/0", "invokeBeanFlow", "invokeBeanFlow/processors/0", "childBean", "myObjectStore", "notificationFlow", "notificationFlow/processors/0", "notificationLoggerObject", "null", "null/0", "null", "null/0", "os-config", "os-contains-flow", "os-contains-flow/processors/0"}));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("myFlow").build()), (Matcher)Matchers.is(Optional.empty()));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("anotherFlow").build()), (Matcher)Matchers.is(Optional.empty()));
    }

    @Description(value="Lazy init should create components when operation is done")
    @Test
    public void lazyMuleContextInitializesLocation() {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("myFlow").build());
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("myFlow").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("anotherFlow").build()), (Matcher)Matchers.is(Optional.empty()));
        Assert.assertThat(this.locator.findAllLocations().stream().map(ComponentLocation::getLocation).collect(Collectors.toList()), (Matcher)IsCollectionContaining.hasItem((Object)"myFlow/source"));
    }

    @Test
    public void objectInitializedWhenReferenceFromJavaInvoke() {
        Location invokeBeanFlow = Location.builder().globalName("invokeBeanFlow").addProcessorsPart().addIndexPart(0).build();
        this.lazyComponentInitializer.initializeComponent(invokeBeanFlow);
        Assert.assertThat((Object)this.registry.lookupByName("childBean").isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat(this.locator.findAllLocations().stream().map(ComponentLocation::getLocation).collect(Collectors.toList()), (Matcher)IsCollectionContaining.hasItem((Object)"childBean"));
    }

    @Test
    public void objectStoreConnectorDoesNotDefineStereotypeOnParameter() {
        Location invokeBeanFlow = Location.builder().globalName("os-contains-flow").addProcessorsPart().addIndexPart(0).build();
        this.lazyComponentInitializer.initializeComponent(invokeBeanFlow);
        Assert.assertThat(this.locator.findAllLocations().stream().map(ComponentLocation::getLocation).collect(Collectors.toList()), (Matcher)IsCollectionContaining.hasItem((Object)"os-config"));
    }

    @Description(value="Lazy init should refresh the ConfigurationComponentLocator when initialize is done")
    @Test
    public void lazyMuleContextRefreshesConfigurationComponentLoader() {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("myFlow").build());
        Assert.assertThat((Object)this.locator.findAllLocations(), (Matcher)Matchers.hasSize((int)98));
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("anotherFlow").build());
        Assert.assertThat((Object)this.locator.findAllLocations(), (Matcher)Matchers.hasSize((int)98));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("myFlow").build()), (Matcher)Matchers.is(Optional.empty()));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("anotherFlow").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
    }

    @Description(value="Lazy init should keep siblings enabled when requested")
    @Test
    public void lazyMuleContextSiblingNodesEnabled() {
        this.lazyComponentInitializer.initializeComponents(componentLocation -> {
            String location = componentLocation.getLocation();
            return location.equals("myFlow/source") || location.equals("myFlow/processors/2/processors/0");
        });
        Assert.assertThat((Object)this.locator.findAllLocations(), (Matcher)Matchers.hasSize((int)98));
        this.lazyComponentInitializer.initializeComponents(componentLocation -> {
            String location = componentLocation.getLocation();
            return location.equals("myFlow/source") || location.equals("myFlow/processors/2/processors/0");
        });
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"myFlow").build()), (Matcher)Matchers.is(Optional.empty()));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"myFlow/source").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"myFlow/processors/2").build()), (Matcher)Matchers.is(Optional.empty()));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"myFlow/processors/2/processors/0").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
    }

    @Test
    public void lazyMuleContextWithDeeperLevelConfig() {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("flowLvl0").build());
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("flowLvl0").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("flowLvl0").addProcessorsPart().addIndexPart(0).build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("flowLvl1").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("flowLvl1").addProcessorsPart().addIndexPart(0).build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("flowLvl2").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("flowLvl2").addProcessorsPart().addIndexPart(0).build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("flowLvl2").addProcessorsPart().addIndexPart(1).build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("dbConfig").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("requestConfig").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("tlsContextRef").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("anonymousProxyConfig").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
    }

    @Test
    public void lazyMuleContextWithRecursiveFlowRefs() {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("flowRecursive").build());
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("flowRecursive").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("flowRecursive").addProcessorsPart().addIndexPart(0).build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
    }

    @Test
    public void fileListShouldInitializeMatcherReference() {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("fileListWithMatcherReference").addProcessorsPart().addIndexPart(0).build());
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("fileListWithMatcherReference").build()), (Matcher)Matchers.is(Optional.empty()));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("fileListWithMatcherReference").addProcessorsPart().addIndexPart(0).build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
    }

    @Test
    public void lazyMuleContextShouldInitializeOnlyTheProcessorRequested() {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("flowLvl2").addProcessorsPart().addIndexPart(1).build());
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("flowLvl2").build()), (Matcher)Matchers.is(Optional.empty()));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("flowLvl2").addProcessorsPart().addIndexPart(0).build()), (Matcher)Matchers.is(Optional.empty()));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("flowLvl2").addProcessorsPart().addIndexPart(1).build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
    }

    @Description(value="Lazy init should create components that are references by other components, when the reference is not a top level element")
    @Test
    public void componentModelReferencesToNonTopLevelElement() {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("aggregatorWithMaxSizeListenerFlow").build());
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("aggregatorWithMaxSizeFlow").build()), (Matcher)Matchers.is(Optional.empty()));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("aggregatorWithMaxSizeFlow").addProcessorsPart().addIndexPart(0).build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("aggregatorWithMaxSizeFlow").addProcessorsPart().addIndexPart(1).build()), (Matcher)Matchers.is(Optional.empty()));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("justAnotherFlowThatShouldNotBeInitialized").build()), (Matcher)Matchers.is(Optional.empty()));
    }

    @Description(value="Search for sub-flows components")
    @Test
    public void findSubFlowComponents() {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName(MY_SUB_FLOW).addProcessorsPart().addIndexPart(0).build());
        Optional componentOptional = this.locator.find(Location.builder().globalName(MY_SUB_FLOW).addProcessorsPart().addIndexPart(0).build());
        Assert.assertThat((Object)componentOptional.isPresent(), (Matcher)Matchers.is((Object)true));
    }

    @Description(value="Initialize flow and referenced sub-flow")
    @Test
    public void findFlowAndSubFlowComponents() {
        this.lazyComponentInitializer.initializeComponents(componentLocation -> componentLocation.getLocation().equals(FLOW_WITH_SUBFLOW));
        Optional componentOptional = this.locator.find(Location.builder().globalName(MY_SUB_FLOW).addProcessorsPart().addIndexPart(0).build());
        Assert.assertThat((Object)componentOptional.isPresent(), (Matcher)Matchers.is((Object)true));
        componentOptional = this.locator.find(Location.builder().globalName(FLOW_WITH_SUBFLOW).addProcessorsPart().addIndexPart(0).build());
        Assert.assertThat((Object)componentOptional.isPresent(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void notificationsObjectInitialized() throws Exception {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("notificationFlow").build());
        this.flowRunner("notificationFlow").run();
        Collection processorNotificationStores = this.registry.lookupAllByType(ProcessorNotificationStore.class);
        Assert.assertThat((Object)processorNotificationStores, (Matcher)Matchers.hasSize((int)1));
        processorNotificationStores.stream().forEach(processorNotificationStore -> Assert.assertThat((Object)processorNotificationStore.getNotifications(), (Matcher)Matchers.hasSize((int)2)));
    }

    @Description(value="Initialize same flow with redelivery policy configured in a listener, test component should not fail when initializing the second time")
    @Test
    public void listenerWithRedeliveryPolicyInitializeMultipleTimes() {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("redeliveryPolicyFlowRef1").build());
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("redeliveryPolicyFlowRef2").build());
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("redeliveryPolicyFlow").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
    }

    @Test
    @Issue(value="MULE-19928")
    @Description(value="Initialize an Object Store inside a redelivery policy")
    public void listenerWithRedeliveryPolicyWithOSInitializeMultipleTimes() {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("redeliveryPolicyWithObjectStoreFlow").build());
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("redeliveryPolicyWithObjectStoreFlow").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
    }
}

