/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config.spring;

import java.util.Arrays;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.serialization.SerializationProtocol;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class InjectDefaultObjectSerializerTestCase
extends AbstractIntegrationTestCase {
    @Inject
    @Named(value="_muleDefaultObjectSerializer")
    private ObjectSerializer defaultSerializer;
    private final String name;
    private final String[] configFiles;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"Default Serializer", new String[0]}, {"Custom Serializer", new String[]{"custom-object-serializer-config.xml"}});
    }

    public InjectDefaultObjectSerializerTestCase(String name, String[] configFiles) {
        this.name = name;
        this.configFiles = configFiles;
    }

    protected String[] getConfigFiles() {
        return this.configFiles;
    }

    @Test
    public void injectObjectSerializer() throws Exception {
        TestObjectSerializerInjectionTarget injectionTarget = (TestObjectSerializerInjectionTarget)muleContext.getInjector().inject((Object)new TestObjectSerializerInjectionTarget());
        Assert.assertThat((Object)muleContext.getObjectSerializer(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)injectionTarget.getObjectSerializer())));
        Assert.assertThat((Object)injectionTarget.getObjectSerializer(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.defaultSerializer)));
    }

    public static class TestSerializationProtocol
    implements ObjectSerializer {
        public SerializationProtocol getInternalProtocol() {
            return null;
        }

        public SerializationProtocol getExternalProtocol() {
            return null;
        }
    }

    public static class TestObjectSerializerInjectionTarget {
        @Inject
        @Named(value="_muleDefaultObjectSerializer")
        private ObjectSerializer objectSerializer;

        public ObjectSerializer getObjectSerializer() {
            return this.objectSerializer;
        }
    }
}

