/*
 * Decompiled with CFR 0.152.
 */
package org.mule.shutdown;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.TestHttpClient;
import org.mule.shutdown.AbstractShutdownTimeoutRequestResponseTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Graceful shutdown")
public class ExpiredShutdownTimeoutRequestResponseTestCase
extends AbstractShutdownTimeoutRequestResponseTestCase {
    @Rule
    public SystemProperty contextShutdownTimeout = new SystemProperty("contextShutdownTimeout", "100");
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder((HttpService)this.getService(HttpService.class)).build();

    protected String getConfigFile() {
        return "org/mule/shutdown/shutdown-timeout-request-response-config.xml";
    }

    @Test
    public void testScriptComponent() throws Throwable {
        this.doShutDownTest("http://localhost:" + this.httpPort.getNumber() + "/scriptComponent");
    }

    @Test
    public void testSetPayload() throws Throwable {
        this.doShutDownTest("http://localhost:" + this.httpPort.getNumber() + "/setPayload");
    }

    @Test
    public void testSetPayloadChoice() throws Throwable {
        this.doShutDownTest("http://localhost:" + this.httpPort.getNumber() + "/setPayloadChoice");
    }

    @Test
    public void testSetPayloadTx() throws Throwable {
        this.doShutDownTest("http://localhost:" + this.httpPort.getNumber() + "/setPayloadTx");
    }

    @Test
    public void testSetPayloadThroughScatterGatherWithFlowRefs() throws Throwable {
        this.doShutDownTest("http://localhost:" + this.httpPort.getNumber() + "/setPayloadSgFr");
    }

    private void doShutDownTest(String url) throws Throwable {
        Future<?> requestTask = this.executor.submit(() -> {
            try {
                new PollingProber().check((Probe)new JUnitLambdaProbe(() -> {
                    HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri(url).entity((HttpEntity)new ByteArrayHttpEntity("Test Message".getBytes()))).method(HttpConstants.Method.POST).build();
                    HttpResponse response = this.httpClient.send(request, HttpRequestOptions.builder().responseTimeout(25000).build());
                    Assert.assertThat((String)"Was able to process message ", (Object)response.getStatusCode(), (Matcher)Matchers.is((Matcher)Matchers.not((Object)HttpConstants.HttpStatus.OK.getStatusCode())));
                    return true;
                }, "Was not able to process message "));
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        });
        waitLatch.await();
        muleContext.stop();
        contextStopLatch.release();
        try {
            requestTask.get();
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }
}

