/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tls.crl.client.ocsp;

import io.qameta.allure.Feature;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.SystemUtils;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tls.crl.AbstractHttpTlsRevocationTestCase;

@Feature(value="TLS/SSL")
public abstract class AbstractHttpOcspRevocationTestCase
extends AbstractHttpTlsRevocationTestCase {
    @Rule
    public DynamicPort dynamicOcspPort;
    @Rule
    public SystemProperty certAliasSystemProperty;
    private static final String RUN_OCSP_SERVER_COMMAND = "openssl ocsp -index test-classes/tls/ocsp/%s -port %d -CA test-classes/tls/ocsp/server.crt -rkey test-classes/tls/ocsp/%s.pem -rsigner test-classes/tls/ocsp/%s.crt";
    static final String REVOKED_OCSP_LIST = "revoked-ocsp.txt";
    static final String VALID_OCSP_LIST = "valid-ocsp.txt";
    protected static final String ENTITY_CERTIFIED_REVOCATION_OCSP_SUB_PATH = "entityOcsp1";
    static final int FIXED_OCSP_PORT = 1111;
    static final String DEFAULT_OCSP_RESPONDER = "server";
    private Process process;
    private final String ocspList;
    private int ocspPort;
    private String ocspResponder;

    AbstractHttpOcspRevocationTestCase(String configFile, String ocspList, String certAlias) {
        super(configFile, ENTITY_CERTIFIED_REVOCATION_OCSP_SUB_PATH);
        this.ocspList = ocspList;
        this.initialiseOcspStatus(certAlias);
    }

    private void initialiseOcspStatus(String certAlias) {
        if (certAlias != null) {
            this.certAliasSystemProperty = new SystemProperty("certAlias", certAlias);
            this.dynamicOcspPort = new DynamicPort("dynamicOcspPort");
            this.ocspPort = this.dynamicOcspPort.getNumber();
            this.ocspResponder = this.certAliasSystemProperty.getValue();
        } else {
            this.ocspPort = 1111;
            this.ocspResponder = DEFAULT_OCSP_RESPONDER;
        }
    }

    @Before
    public void setUp() throws Exception {
        Assume.assumeFalse((boolean)SystemUtils.IS_OS_WINDOWS);
        String openSslCmd = String.format(RUN_OCSP_SERVER_COMMAND, this.ocspList, this.ocspPort, this.ocspResponder, this.ocspResponder);
        LOGGER.info("Openssl Command: {}", (Object)openSslCmd);
        this.process = Runtime.getRuntime().exec(openSslCmd);
        String cmdOutput = this.getOcspServerCommandOutput(this.process.getErrorStream());
        LOGGER.info("Command output: {}", (Object)cmdOutput);
        Assume.assumeFalse((String)"Since openssl ocsp command has a flaky behavior the test will be ignored if an error occurs in server initialisation.", (boolean)cmdOutput.contains("Error"));
    }

    @After
    public void tearDown() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    private String getOcspServerCommandOutput(InputStream commandOutput) throws IOException {
        char aux;
        StringBuilder stringBuilder = new StringBuilder();
        while ((aux = (char)commandOutput.read()) != '\n') {
            stringBuilder.append(aux);
        }
        return stringBuilder.toString();
    }
}

