/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tls.crl.client;

import java.security.cert.CertPathValidatorException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mule.tls.crl.AbstractHttpTlsRevocationTestCase;
import org.mule.tls.fips.DefaultTestConfiguration;

public class HttpPreferringCrlTestCase
extends AbstractHttpTlsRevocationTestCase {
    public static final String EXPECTED_OCSP_ERROR_MESSAGE = "Certificate does not specify OCSP responder";

    public HttpPreferringCrlTestCase() {
        super("http-requester-tls-crl-standard-config.xml", "tls/crl/validCrl", "entity3");
    }

    @BeforeClass
    public static void before() {
        Assume.assumeFalse((String)"W-16968647: Check that this is not in fips where the standard revocation check does not work. Another of the documented options should be used", (boolean)DefaultTestConfiguration.isFipsTesting());
    }

    @Test
    public void testPreferCrlWithFallback() {
        this.verifyRevocationForFlow("testFlowPreferCrl");
    }

    @Test
    public void testPreferCrlNoFallback() {
        this.verifyRevocationForFlow("testFlowPreferCrlNoFallback");
    }

    @Test
    public void testNotPreferCrlWithFallback() {
        this.verifyRevocationForFlow("testFlowNotPreferCrl");
    }

    @Test
    public void testNotPreferCrlNoFallback() {
        Exception exception = (Exception)Assert.assertThrows(Exception.class, () -> this.runFlow("testFlowNotPreferCrlNoFallback"));
        Throwable rootException = ExceptionUtils.getRootCause((Throwable)exception);
        MatcherAssert.assertThat((Object)rootException, (Matcher)Is.is((Matcher)CoreMatchers.instanceOf(CertPathValidatorException.class)));
        MatcherAssert.assertThat((Object)rootException.getMessage(), (Matcher)Is.is((Object)EXPECTED_OCSP_ERROR_MESSAGE));
    }

    private void verifyRevocationForFlow(String testFlowPreferCrl) {
        Exception exception = (Exception)Assert.assertThrows(Exception.class, () -> this.runFlow(testFlowPreferCrl));
        this.verifyRevocationException(exception);
    }
}

