/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.message.Message;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tests.api.TestQueueManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Feature(value="Routers")
@Story(value="Round Robin")
public class RoundRobinTestCase
extends AbstractIntegrationTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoundRobinTestCase.class);
    private static final int NUMBER_OF_MESSAGES = 10;
    private static final int NUMBER_OF_WRITERS = 10;
    private static final int NUMBER_OF_ENDPOINTS = 5;
    @Inject
    private TestQueueManager queueManager;

    protected String getConfigFile() {
        return "round-robin-test.xml";
    }

    @Test
    public void testRoundRobin() throws Exception {
        ArrayList<Thread> writers = new ArrayList<Thread>();
        for (int i = 0; i < 10; ++i) {
            writers.add(new Thread(new MessageWriter(i)));
        }
        for (Thread writer : writers) {
            writer.start();
        }
        for (Thread writer : writers) {
            writer.join();
        }
        int j = 0;
        for (int i = 0; i < 100; ++i) {
            String path = "output" + j;
            Message msg = this.queueManager.read(path, 0L, TimeUnit.MILLISECONDS).getMessage();
            Assert.assertNotNull((Object)msg);
            LOGGER.debug(path + ": " + this.getPayloadAsString(msg));
            j = (j + 1) % 5;
        }
    }

    @Test
    public void testRoundRobinNonBlocking() throws Exception {
        ((FlowRunner)this.flowRunner("test-router-nb").withPayload((Object)"AmI_NB?")).runAndVerify(new String[]{"test-router-nb"});
    }

    class MessageWriter
    implements Runnable {
        private final int id;

        MessageWriter(int id) {
            this.id = id;
        }

        @Override
        public void run() {
            for (int i = 0; i < 10; ++i) {
                try {
                    ((FlowRunner)RoundRobinTestCase.this.flowRunner("test-router").withPayload((Object)("Writer " + this.id + " Message " + i))).run();
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.info("Unexpected exception dispatching message", (Throwable)ex);
                }
            }
        }
    }
}

