/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.kerberos;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.integration.kerberos.KerberosTestInfrastructure;

public class KerberosProxyIntegrationTestCase
extends AbstractIntegrationTestCase {
    private static KerberosTestInfrastructure kdcInfrastructure;
    @Rule
    public DynamicPort proxyPort = new DynamicPort("proxyPort");
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");
    @Rule
    public WireMockRule mockProxyServer = new WireMockRule((Options)WireMockConfiguration.options().bindAddress("127.0.0.1").port(this.proxyPort.getNumber()));
    @Rule
    public WireMockRule mockTargetServer = new WireMockRule((Options)WireMockConfiguration.options().bindAddress("127.0.0.1").port(this.httpPort.getNumber()));

    @BeforeClass
    public static void setUpKerberosInfrastructure() throws Exception {
        kdcInfrastructure = new KerberosTestInfrastructure();
        kdcInfrastructure.start();
        Files.copy(kdcInfrastructure.getClientKeytab().toPath(), Paths.get("/tmp/client.keytab", new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    @Before
    public void setUpMockStubs() {
        this.mockProxyServer.resetAll();
        this.mockTargetServer.resetAll();
        this.mockProxyServer.stubFor(WireMock.any((UrlPattern)WireMock.urlPathMatching((String)"/.*")).withHeader("Proxy-Authorization", WireMock.absent()).willReturn(WireMock.aResponse().withStatus(407).withHeader("Proxy-Authenticate", new String[]{"Negotiate"}).withHeader("Content-Type", new String[]{"text/plain"}).withBody("Proxy Authentication Required")));
        this.mockProxyServer.stubFor(WireMock.any((UrlPattern)WireMock.urlPathMatching((String)"/.*")).withHeader("Proxy-Authorization", WireMock.matching((String)"Negotiate [A-Za-z0-9+/=]+")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom("http://localhost:" + this.httpPort.getNumber())));
        this.mockTargetServer.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/test")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/plain"})));
    }

    @AfterClass
    public static void tearDownKerberosInfrastructure() throws Exception {
        if (kdcInfrastructure != null) {
            kdcInfrastructure.stop();
            Files.deleteIfExists(Paths.get("/tmp/client.keytab", new String[0]));
        }
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/kerberos/kerberos-proxy-authentication-config.xml";
    }

    @Test
    public void testEndToEndKerberosProxyAuthenticationFlow() throws Exception {
        FlowRunner kerberosFlow = this.flowRunner("testKerberosProxyAuthenticationFlow");
        CoreEvent result = kerberosFlow.run();
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Map responseMap = (Map)result.getMessage().getPayload().getValue();
        MatcherAssert.assertThat(responseMap.get("status"), (Matcher)Is.is((Object)"success"));
        MatcherAssert.assertThat(responseMap.get("authentication"), (Matcher)Is.is((Object)"kerberos_proxy"));
        MatcherAssert.assertThat(responseMap.get("response_status"), (Matcher)Is.is((Object)200));
        this.mockProxyServer.verify(1, WireMock.getRequestedFor((UrlPattern)WireMock.anyUrl()).withHeader("Proxy-Authorization", WireMock.absent()));
        this.mockProxyServer.verify(1, WireMock.getRequestedFor((UrlPattern)WireMock.anyUrl()).withHeader("Proxy-Authorization", WireMock.matching((String)"Negotiate [A-Za-z0-9+/=]+")));
        this.mockProxyServer.verify(2, WireMock.getRequestedFor((UrlPattern)WireMock.anyUrl()));
        this.mockTargetServer.verify(1, WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/test")));
        MatcherAssert.assertThat(responseMap.get("response_headers"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void testKerberosProxyAuthenticationFlowPreemptive() throws Exception {
        FlowRunner kerberosFlow = this.flowRunner("testKerberosProxyAuthenticationFlowPreemptive");
        CoreEvent result = kerberosFlow.run();
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Map responseMap = (Map)result.getMessage().getPayload().getValue();
        MatcherAssert.assertThat(responseMap.get("status"), (Matcher)Is.is((Object)"success"));
        MatcherAssert.assertThat(responseMap.get("authentication"), (Matcher)Is.is((Object)"kerberos_proxy_preemptive"));
        MatcherAssert.assertThat(responseMap.get("response_status"), (Matcher)Is.is((Object)200));
        this.mockProxyServer.verify(1, WireMock.getRequestedFor((UrlPattern)WireMock.anyUrl()).withHeader("Proxy-Authorization", WireMock.matching((String)"Negotiate [A-Za-z0-9+/=]+")));
        this.mockProxyServer.verify(1, WireMock.getRequestedFor((UrlPattern)WireMock.anyUrl()));
        this.mockTargetServer.verify(1, WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/test")));
        MatcherAssert.assertThat(responseMap.get("response_headers"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }
}

