/*
 * Decompiled with CFR 0.152.
 */
package org.mule.shutdown;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.report.HeapDumpOnFailure;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Graceful shutdown")
public class ShutdownAppEventLeakTestCase
extends AbstractIntegrationTestCase {
    private static final int PROBER_POLLING_INTERVAL = 100;
    private static final int PROBER_POLIING_TIMEOUT = 5000;
    private static final int MESSAGE_TIMEOUT = 2000;
    @Rule
    public HeapDumpOnFailure heapDumpOnFailure = new HeapDumpOnFailure();
    private CloseableHttpClient httpClient;
    private static final Set<PhantomReference<CoreEvent>> requestContextRefs = new HashSet<PhantomReference<CoreEvent>>();
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");

    @Before
    public void before() {
        this.httpClient = HttpClients.createDefault();
        requestContextRefs.clear();
    }

    @After
    public void after() throws IOException {
        this.httpClient.close();
    }

    protected String getConfigFile() {
        return "org/mule/shutdown/app-with-flows.xml";
    }

    @Test
    public void httpListener() throws IOException, TimeoutException {
        MuleContext muleContextForApp = muleContext;
        HttpGet request = new HttpGet("http://localhost:" + this.httpPort.getNumber() + "/sync");
        this.httpClient.execute((HttpUriRequest)request);
        muleContextForApp.dispose();
        this.assertEventsUnreferenced();
    }

    @Test
    public void httpListenerNonBlocking() throws IOException, TimeoutException {
        MuleContext muleContextForApp = muleContext;
        HttpGet request = new HttpGet("http://localhost:" + this.httpPort.getNumber() + "/nonBlocking");
        this.httpClient.execute((HttpUriRequest)request);
        muleContextForApp.dispose();
        this.assertEventsUnreferenced();
    }

    @Test
    public void httpRequest() throws IOException, TimeoutException {
        MuleContext muleContextForApp = muleContext;
        HttpGet request = new HttpGet("http://localhost:" + this.httpPort.getNumber() + "/request");
        this.httpClient.execute((HttpUriRequest)request);
        muleContextForApp.dispose();
        this.assertEventsUnreferenced();
    }

    private void assertEventsUnreferenced() {
        new PollingProber(5000L, 100L).check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                System.gc();
                for (PhantomReference<CoreEvent> phantomReference : requestContextRefs) {
                    MatcherAssert.assertThat((Object)phantomReference.isEnqueued(), (Matcher)CoreMatchers.is((Object)true));
                }
                return true;
            }
        });
    }

    public static class RetrieveRequestContext
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            requestContextRefs.add(new PhantomReference<PrivilegedEvent>(PrivilegedEvent.getCurrentEvent(), new ReferenceQueue()));
            return event;
        }
    }
}

