/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.properties;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Configuration properties")
@Story(value="Component configuration properties resolver story")
public class LocalisationPropertiesResolverExtensionTestCase
extends AbstractIntegrationTestCase {
    @Inject
    private ConfigurationProperties configurationProperties;
    private final String configFile;

    public LocalisationPropertiesResolverExtensionTestCase() {
        this.configFile = "properties/localisation-properties-resolver-extension-config.xml";
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Test
    @Issue(value="MULE-19428")
    @Description(value="Verifies that given a locale and a pattern, a certain number can be formatted correctly using a properties resolver extension")
    public void propertiesAreResolvedCorrectlyAndNumberIsFormattedAccordingToLocale() {
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance(new Locale("pt", "PT"));
        formatter.applyPattern("#,##0.00");
        MatcherAssert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty("key1").get()), (Matcher)Is.is((Object)formatter.format(Double.parseDouble("25837889.4535"))));
    }
}

