/*
 * Decompiled with CFR 0.152.
 */
package org.mule.shutdown;

import io.qameta.allure.Feature;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.core.IsIterableContaining;
import org.junit.Test;
import org.mule.runtime.api.alert.TimedDataAggregation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.shutdown.AbstractShutdownTimeoutRequestResponseTestCase;
import org.mule.tck.probe.PollingProber;

@Feature(value="Lifecycle and Dependency Injection")
@Stories(value={@Story(value="Dispatch to flow"), @Story(value="Graceful shutdown")})
public class RogueExtensionShutdownTestCase
extends AbstractShutdownTimeoutRequestResponseTestCase {
    @Inject
    @Named(value="neverStoppingSourceFlow")
    private FlowConstruct neverStoppingSourceFlow;
    @Inject
    @Named(value="stopFailsSourceFlow")
    private FlowConstruct stopFailsSourceFlow;
    @Inject
    @Named(value="stopHangsSourceFlow")
    private FlowConstruct stopHangsSourceFlow;

    protected String getConfigFile() {
        return "org/mule/shutdown/rogue.xml";
    }

    @Test
    public void neverStoppingSource() throws Exception {
        LifecycleUtils.startIfNeeded((Object)this.neverStoppingSourceFlow);
        Executors.newSingleThreadExecutor().submit(() -> {
            try {
                LifecycleUtils.stopIfNeeded((Object)this.neverStoppingSourceFlow);
            }
            catch (MuleException e) {
                e.printStackTrace();
            }
        });
        this.probleForEventDispatchedAfterStopAlert("rogue:never-stopping-source", "neverStoppingSourceFlow");
    }

    @Test
    public void stopFailsSource() throws Exception {
        LifecycleUtils.startIfNeeded((Object)this.stopFailsSourceFlow);
        Executors.newSingleThreadExecutor().submit(() -> {
            try {
                LifecycleUtils.stopIfNeeded((Object)this.stopFailsSourceFlow);
            }
            catch (MuleException e) {
                e.printStackTrace();
            }
        });
        this.probleForEventDispatchedAfterStopAlert("rogue:stop-fails-source", "stopFailsSourceFlow");
    }

    @Test
    public void stopHangsSource() throws Exception {
        LifecycleUtils.startIfNeeded((Object)this.stopHangsSourceFlow);
        Future<?> stopSubmit = Executors.newSingleThreadExecutor().submit(() -> {
            try {
                LifecycleUtils.stopIfNeeded((Object)this.stopHangsSourceFlow);
            }
            catch (MuleException e) {
                e.printStackTrace();
            }
        });
        this.probleForEventDispatchedAfterStopAlert("rogue:stop-hangs-source", "stopHangsSourceFlow");
        stopSubmit.cancel(true);
    }

    private void probleForEventDispatchedAfterStopAlert(String sourceId, String flowName) {
        PollingProber.probe(() -> {
            Map aggregatedAlerts = this.alertingSupport.alertsAggregation(() -> new HashSet(), (items, newItem) -> {
                items.add(newItem);
                return items;
            });
            MatcherAssert.assertThat((Object)aggregatedAlerts, (Matcher)IsMapContaining.hasKey((Object)"EVENT_DISPATCHED_AFTER_STOP"));
            MatcherAssert.assertThat((Object)((HashSet)((TimedDataAggregation)aggregatedAlerts.get("EVENT_DISPATCHED_AFTER_STOP")).forLast1MinInterval()), (Matcher)IsIterableContaining.hasItem(Arrays.asList(sourceId, flowName)));
            return true;
        });
    }
}

