/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.test.integration.exceptions;

import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.transformer.AbstractTransformer;

import java.nio.charset.Charset;

public class AlwaysRaiseExceptionTransformer extends AbstractTransformer {

  @Override
  protected Object doTransform(Object src, Charset enc) throws TransformerException {
    throw new TransformerException(I18nMessageFactory.createStaticMessage("Ad hoc message exception"));
  }
}
