/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tls.crl.client.ocsp;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.test.runner.RunnerDelegateTo;
import org.mule.tls.crl.client.ocsp.AbstractHttpOcspRevocationTestCase;
import org.mule.tls.fips.DefaultTestConfiguration;

@RunnerDelegateTo(value=Parameterized.class)
public class HttpRequesterOcspRevocationTestCase
extends AbstractHttpOcspRevocationTestCase {
    @BeforeClass
    public static void before() {
        Assume.assumeFalse((String)"W-16968647: Check that this is not in fips where the standard revocation check does not work. Another of the documented options should be used", (boolean)DefaultTestConfiguration.isFipsTesting());
    }

    public HttpRequesterOcspRevocationTestCase(String configFile, String certAlias) {
        super(configFile, "revoked-ocsp.txt", certAlias);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"http-requester-ocsp-revocation-config.xml", null}, {"http-requester-ocsp-revocation-custom-provider-config.xml", "server"}, {"http-requester-ocsp-revocation-custom-provider-config.xml", "thirdParty"});
    }

    @Test
    public void testServerCertifiedAndRevoked() {
        Exception exception = (Exception)Assert.assertThrows(Exception.class, () -> this.runRevocationTestFlow());
        this.verifyRevocationException(exception);
    }
}

