/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tls;

import io.qameta.allure.Feature;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tls.fips.DefaultTestConfiguration;

@Feature(value="TLS/SSL")
public class TlsCustomConfigMultipleKeysTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Rule
    public SystemProperty serverKeyStoreType = new SystemProperty("storeType", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestStoreType());
    @Rule
    public SystemProperty tlsClientServerKeyStore = new SystemProperty("tlsClientServerKeyStore", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTlsClientKeyStoreWithMultipleKeys());
    @Rule
    public SystemProperty tlsTrustStore = new SystemProperty("tlsTrustStore", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestGenericTrustKeyStore());
    @Rule
    public SystemProperty tlsTrustStoreFileWithoutMuleServerCertificate = new SystemProperty("tlsTrustStoreFileWithoutMuleServerCertificate", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTlsTrustStoreFileWithoutMuleServerCertificate());

    protected String getConfigFile() {
        return "http-listener-custom-tls-multiple-keys-config.xml";
    }

    @Test
    public void acceptsConnectionWithValidCertificate() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("testFlowClientWithCertificate").withPayload((Object)"Test Message")).run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"Test Message"));
    }

    @Test
    public void rejectsConnectionWithInvalidCertificate() {
        FlowRunner flow = (FlowRunner)this.flowRunner("testFlowClientWithoutCertificate").withPayload((Object)"Test Message");
        MessagingException thrown = (MessagingException)Assert.assertThrows(MessagingException.class, () -> ((FlowRunner)flow).run());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)"General SSLEngine problem"), CoreMatchers.containsString((String)"Certificate signature validation failed"), CoreMatchers.containsString((String)"PKIX path building failed"), CoreMatchers.containsString((String)"PKIX path validation failed"), CoreMatchers.containsString((String)"certificate_unknown")}));
    }
}

