/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.interception;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapContaining;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.runtime.api.interception.SourceInterceptor;
import org.mule.runtime.api.interception.SourceInterceptorFactory;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.tck.probe.PollingProber;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.heisenberg.extension.HeisenbergConnectionProvider;
import org.mule.test.heisenberg.extension.HeisenbergSource;
import org.mule.test.integration.interception.ProcessorInterceptorFactoryTestCase;

@Feature(value="Interception API")
@Story(value="Component Interception Story")
public class SourceInterceptorFactoryTestCase
extends AbstractIntegrationTestCase {
    private Flow flow;
    private static CountDownLatch latch;
    @Inject
    @Named(value="withMaxConcurrency")
    public Flow withMaxConcurrency;

    protected String getConfigFile() {
        return "org/mule/test/integration/interception/source-interceptor-factory.xml";
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        objects.put("_SourceCallbackInterceptor", new SourceCallbackInterceptorFactory());
        return objects;
    }

    @Before
    public void before() {
        latch = new CountDownLatch(1);
    }

    @After
    public void after() throws MuleException {
        if (this.flow != null) {
            this.flow.stop();
        }
        HeisenbergConnectionProvider.getActiveConnections().clear();
        SourceCallbackInterceptor.interceptionParameters.clear();
        SourceCallbackInterceptor.afterCallback = (event, thrown) -> {};
        SourceCallbackInterceptor.afterTerminated = (componentLocation, eventContext) -> {};
        HeisenbergSource.resetHeisenbergSource();
    }

    @Test
    public void sourceIntercepted() throws Exception {
        this.startFlow("sourceIntercepted");
        CountDownLatch afterCalledLatch = new CountDownLatch(1);
        SourceCallbackInterceptor.afterCallback = (event, thrown) -> {
            if (!thrown.isPresent()) {
                afterCalledLatch.countDown();
            }
        };
        MatcherAssert.assertThat((Object)afterCalledLatch.await(5000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)true));
        List<ProcessorInterceptorFactoryTestCase.InterceptionParameters> interceptionParameters = SourceCallbackInterceptor.interceptionParameters;
        MatcherAssert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1))));
        ProcessorInterceptorFactoryTestCase.InterceptionParameters heisenbergSourceInterceptionParameter = interceptionParameters.get(0);
        MatcherAssert.assertThat((String)heisenbergSourceInterceptionParameter.toString(), heisenbergSourceInterceptionParameter.getParameters().entrySet(), (Matcher)Matchers.hasSize((int)14));
        MatcherAssert.assertThat((String)heisenbergSourceInterceptionParameter.toString(), heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"description"));
        MatcherAssert.assertThat((String)heisenbergSourceInterceptionParameter.toString(), heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"primaryNodeOnly"));
        MatcherAssert.assertThat((String)heisenbergSourceInterceptionParameter.toString(), heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"nextDoor"));
        MatcherAssert.assertThat((String)heisenbergSourceInterceptionParameter.toString(), heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"fail"));
        MatcherAssert.assertThat((String)heisenbergSourceInterceptionParameter.toString(), heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"config-ref"));
        MatcherAssert.assertThat((String)heisenbergSourceInterceptionParameter.toString(), heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"initialBatchNumber"));
        MatcherAssert.assertThat((String)heisenbergSourceInterceptionParameter.toString(), heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"payment"));
        MatcherAssert.assertThat((String)heisenbergSourceInterceptionParameter.toString(), heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"frequency"));
        MatcherAssert.assertThat((String)heisenbergSourceInterceptionParameter.toString(), heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"propagateError"));
        MatcherAssert.assertThat((String)heisenbergSourceInterceptionParameter.toString(), heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"corePoolSize"));
        MatcherAssert.assertThat((String)heisenbergSourceInterceptionParameter.toString(), heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"onCapacityOverload"));
        MatcherAssert.assertThat(heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"myName"));
        MatcherAssert.assertThat(heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"age"));
        MatcherAssert.assertThat(heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"knownAddresses"));
    }

    @Test
    public void sourceErrorIntercepted() throws Exception {
        this.startFlow("sourceErrorIntercepted");
        CountDownLatch afterCalledLatch = new CountDownLatch(1);
        SourceCallbackInterceptor.afterCallback = (event, thrown) -> thrown.ifPresent(t -> afterCalledLatch.countDown());
        MatcherAssert.assertThat((Object)afterCalledLatch.await(5000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)true));
        List<ProcessorInterceptorFactoryTestCase.InterceptionParameters> interceptionParameters = SourceCallbackInterceptor.interceptionParameters;
        MatcherAssert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1))));
        ProcessorInterceptorFactoryTestCase.InterceptionParameters heisenbergSourceInterceptionParameter = interceptionParameters.get(interceptionParameters.size() - 1);
        MatcherAssert.assertThat((String)heisenbergSourceInterceptionParameter.toString(), heisenbergSourceInterceptionParameter.getParameters().entrySet(), (Matcher)Matchers.hasSize((int)14));
    }

    @Test
    public void sourceInterceptedWithFailingProcessor() throws Exception {
        this.startFlow("sourceInterceptedWithFailingProcessor");
        CountDownLatch afterCalledLatch = new CountDownLatch(1);
        SourceCallbackInterceptor.afterCallback = (event, thrown) -> {
            if (event.getError().isPresent()) {
                ErrorType errorType = ((Error)event.getError().get()).getErrorType();
                MatcherAssert.assertThat((Object)errorType.getNamespace(), (Matcher)Matchers.equalTo((Object)"APP"));
                MatcherAssert.assertThat((Object)errorType.getIdentifier(), (Matcher)Matchers.equalTo((Object)"RAISED"));
                afterCalledLatch.countDown();
            }
        };
        MatcherAssert.assertThat((Object)afterCalledLatch.await(5000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)true));
        List<ProcessorInterceptorFactoryTestCase.InterceptionParameters> interceptionParameters = SourceCallbackInterceptor.interceptionParameters;
        MatcherAssert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1))));
        ProcessorInterceptorFactoryTestCase.InterceptionParameters heisenbergSourceInterceptionParameter = interceptionParameters.get(0);
        MatcherAssert.assertThat(heisenbergSourceInterceptionParameter.getParameters().entrySet(), (Matcher)Matchers.hasSize((int)14));
        MatcherAssert.assertThat(heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"description"));
        MatcherAssert.assertThat(heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"primaryNodeOnly"));
        MatcherAssert.assertThat(heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"nextDoor"));
        MatcherAssert.assertThat(heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"fail"));
        MatcherAssert.assertThat(heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"config-ref"));
        MatcherAssert.assertThat(heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"initialBatchNumber"));
        MatcherAssert.assertThat(heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"payment"));
        MatcherAssert.assertThat(heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"frequency"));
        MatcherAssert.assertThat(heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"propagateError"));
        MatcherAssert.assertThat(heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"corePoolSize"));
        MatcherAssert.assertThat(heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"onCapacityOverload"));
        MatcherAssert.assertThat(heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"myName"));
        MatcherAssert.assertThat(heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"age"));
        MatcherAssert.assertThat(heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"knownAddresses"));
    }

    @Test
    public void sourceInterceptedAfterTerminated() throws Exception {
        this.startFlow("sourceInterceptedAfterTerminated");
        CountDownLatch afterCalledLatch = new CountDownLatch(1);
        AtomicReference eventContextAtomicReference = new AtomicReference();
        SourceCallbackInterceptor.afterTerminated = (componentLocation, eventContext) -> {
            eventContextAtomicReference.set((BaseEventContext)eventContext);
            afterCalledLatch.countDown();
        };
        MatcherAssert.assertThat((Object)afterCalledLatch.await(5000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((BaseEventContext)eventContextAtomicReference.get()).isTerminated(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void sourceErrorInterceptedAfterTerminated() throws Exception {
        this.startFlow("sourceErrorInterceptedAfterTerminated");
        CountDownLatch afterCalledLatch = new CountDownLatch(1);
        AtomicReference eventContextAtomicReference = new AtomicReference();
        SourceCallbackInterceptor.afterTerminated = (componentLocation, eventContext) -> {
            eventContextAtomicReference.set((BaseEventContext)eventContext);
            afterCalledLatch.countDown();
        };
        MatcherAssert.assertThat((Object)afterCalledLatch.await(5000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((BaseEventContext)eventContextAtomicReference.get()).isTerminated(), (Matcher)Matchers.is((Object)true));
        List<ProcessorInterceptorFactoryTestCase.InterceptionParameters> interceptionParameters = SourceCallbackInterceptor.interceptionParameters;
        MatcherAssert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1))));
        ProcessorInterceptorFactoryTestCase.InterceptionParameters heisenbergSourceInterceptionParameter = interceptionParameters.get(interceptionParameters.size() - 1);
        MatcherAssert.assertThat((String)heisenbergSourceInterceptionParameter.toString(), heisenbergSourceInterceptionParameter.getParameters().entrySet(), (Matcher)Matchers.hasSize((int)14));
    }

    @Test
    public void sourceInterceptedAfterTerminatedWithFailingProcessor() throws Exception {
        this.startFlow("sourceInterceptedAfterTerminatedWithFailingProcessor");
        CountDownLatch afterCalledLatch = new CountDownLatch(1);
        AtomicReference eventContextAtomicReference = new AtomicReference();
        SourceCallbackInterceptor.afterTerminated = (componentLocation, eventContext) -> {
            eventContextAtomicReference.set((BaseEventContext)eventContext);
            afterCalledLatch.countDown();
        };
        MatcherAssert.assertThat((Object)afterCalledLatch.await(5000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((BaseEventContext)eventContextAtomicReference.get()).isTerminated(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void sourceInterceptedAfterTerminatedWithFailingReferencedFlow() throws Exception {
        this.startFlow("sourceInterceptedAfterTerminatedWithFailingReferencedFlow");
        CountDownLatch afterCalledLatch = new CountDownLatch(1);
        AtomicReference eventContextAtomicReference = new AtomicReference();
        SourceCallbackInterceptor.afterTerminated = (componentLocation, eventContext) -> {
            eventContextAtomicReference.set((BaseEventContext)eventContext);
            afterCalledLatch.countDown();
        };
        MatcherAssert.assertThat((Object)afterCalledLatch.await(5000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((BaseEventContext)eventContextAtomicReference.get()).isTerminated(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void sourceInterceptedWithFlowThatEndsAfterAsync() throws Exception {
        AtomicBoolean afterCallbackRun = new AtomicBoolean();
        AtomicReference eventContextAtomicReference = new AtomicReference();
        SourceCallbackInterceptor.afterTerminated = (componentLocation, eventContext) -> {
            eventContextAtomicReference.set((BaseEventContext)eventContext);
            afterCallbackRun.set(true);
        };
        this.flowRunner("FlowThatEndsAfterAsync").run();
        latch.countDown();
        PollingProber.probe(afterCallbackRun::get);
        MatcherAssert.assertThat((Object)((BaseEventContext)eventContextAtomicReference.get()).isTerminated(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    @Story(value="Backpressure")
    public void sourceInterceptedWithFlowThatEndsBeforeAsync() throws MuleException {
        AtomicInteger afterCounter = new AtomicInteger();
        AtomicReference eventContextAtomicReference = new AtomicReference();
        SourceCallbackInterceptor.afterTerminated = (componentLocation, eventContext) -> {
            eventContextAtomicReference.set((BaseEventContext)eventContext);
            afterCounter.incrementAndGet();
        };
        this.withMaxConcurrency.start();
        latch.countDown();
        PollingProber.probe(() -> afterCounter.get() > 1);
        MatcherAssert.assertThat((Object)((BaseEventContext)eventContextAtomicReference.get()).isTerminated(), (Matcher)Matchers.is((Object)true));
    }

    private void startFlow(String flowName) throws Exception {
        this.flow = (Flow)this.getFlowConstruct(flowName);
        this.flow.start();
    }

    public static Object await(Object payload) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return payload;
    }

    public static class SourceCallbackInterceptorFactory
    implements SourceInterceptorFactory {
        public SourceInterceptor get() {
            return new SourceCallbackInterceptor();
        }
    }

    public static class SourceCallbackInterceptor
    implements SourceInterceptor {
        static BiConsumer<InterceptionEvent, Optional<Throwable>> afterCallback = (event, thrown) -> {};
        static BiConsumer<ComponentLocation, EventContext> afterTerminated = (componentLocation, eventContext) -> {};
        static final List<ProcessorInterceptorFactoryTestCase.InterceptionParameters> interceptionParameters = new LinkedList<ProcessorInterceptorFactoryTestCase.InterceptionParameters>();

        public void beforeCallback(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event) {
            interceptionParameters.add(new ProcessorInterceptorFactoryTestCase.InterceptionParameters(location, parameters, event));
        }

        public void afterCallback(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
            afterCallback.accept(event, thrown);
        }

        public void afterTerminated(ComponentLocation location, EventContext eventContext) {
            afterTerminated.accept(location, eventContext);
        }
    }
}

