/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.core.context.notification;

import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.notification.ErrorHandlerNotification;
import org.mule.runtime.api.notification.IntegerAction;
import org.mule.runtime.api.notification.Notification;
import org.mule.test.core.context.notification.AbstractNotificationTestCase;
import org.mule.test.core.context.notification.Node;
import org.mule.test.core.context.notification.RestrictedNode;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class ErrorHandlerNotificationTestCase
extends AbstractNotificationTestCase {
    private final String flowName;
    private final Consumer<ExpectedError> expected;
    @Rule
    public ExpectedError expectedError = ExpectedError.none();

    @Parameterized.Parameters(name="{0}")
    public static Object[][] params() {
        return new Object[][]{{"catch-es", expected -> {}}, {"choice-es", expected -> {}}, {"rollback-es", expected -> expected.expectErrorType("APP", "EXPECTED")}, {"default-es", expected -> expected.expectErrorType("APP", "EXPECTED")}};
    }

    public ErrorHandlerNotificationTestCase(String flowName, Consumer<ExpectedError> expected) {
        this.flowName = flowName;
        this.expected = expected;
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/notifications/exception-strategy-notification-test-flow.xml";
    }

    @Test
    public void doTest() throws Exception {
        this.expected.accept(this.expectedError);
        try {
            Assert.assertNotNull((Object)((FlowRunner)this.flowRunner(this.flowName).withPayload((Object)"test")).run());
        }
        finally {
            this.assertNotifications();
        }
    }

    @Override
    public RestrictedNode getSpecification() {
        return new Node().parallel(this.node((Notification.Action)new IntegerAction(2001))).parallel(this.node((Notification.Action)new IntegerAction(2002)));
    }

    private RestrictedNode node(Notification.Action action) {
        return new Node(ErrorHandlerNotification.class, action);
    }

    @Override
    public void validateSpecification(RestrictedNode spec) throws Exception {
    }
}

