/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;

@Issue(value="MULE-18770")
@Feature(value="Correlation ID")
@Story(value="Sources' correlation id generation")
public class SourceCorrelationIdNoConfigTestCase
extends AbstractIntegrationTestCase {
    private static final String EXPECTED_CORRELATION_ID_UUID_FORMAT = "^.+-.+-.+-.+-.+$";
    @Rule
    public DynamicPort listenPort = new DynamicPort("port");
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder((HttpService)this.getService(HttpService.class)).build();

    protected String getConfigFile() {
        return "org/mule/test/config/correlation-id/no-config.xml";
    }

    @Test
    public void execute() throws Exception {
        HttpRequest request = HttpRequest.builder().uri("http://localhost:" + this.listenPort.getNumber() + "/test").method(HttpConstants.Method.GET).build();
        HttpResponse response = this.httpClient.send(request, HttpRequestOptions.builder().responseTimeout(10000).build());
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.is((Object)200));
        String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)result.matches(EXPECTED_CORRELATION_ID_UUID_FORMAT), (Matcher)CoreMatchers.is((Object)true));
    }
}

