/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transaction;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.profiling.ProfilingDataConsumer;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.TransactionProfilingEventContext;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class TransactionRolledBackByOwnerTestCase
extends AbstractIntegrationTestCase {
    private static final int POLL_DELAY_MILLIS = 100;
    private final FlowExecutions flowExecutions;
    @Inject
    private PrivilegedProfilingService service;
    private List<String> states;
    private final Object statesLock = new Object();
    private Map<String, List<String>> statesPerLocation;
    private final String config;
    @ClassRule
    public static SystemProperty enableProfilingService = new SystemProperty("mule.enable.profiling.service", "true");
    @ClassRule
    public static SystemProperty enableProfilingConsumers = new SystemProperty("mule.force.runtime.profiling.consumers.enablement", "true");
    @Rule
    public SystemProperty defaultErrorHandler = new SystemProperty("mule.enable.default.errorhandler.not.rollback.incorrect.tx", "true");

    @Parameterized.Parameters(name="{0} - {2}")
    public static Object[][] params() {
        return new Object[][]{{"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "no-rollback", new FlowExecutions("no-rollback", false, "commit", null)}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "rollback", new FlowExecutions("rollback", true, "rollback", null)}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "no-rollback-outside-try", new FlowExecutions("no-rollback-outside-try", true, "commit", null)}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "no-rollback-flowref", new FlowExecutions("no-rollback-flowref", false, "commit", null)}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "no-rollback-error-in-flow-ref", new FlowExecutions("no-rollback-error-in-flow-ref", false, "commit", null)}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "rollback-error-in-flow-ref-with-try", new FlowExecutions("rollback-error-in-flow-ref-with-try", true, "rollback", null)}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "no-rollback-error-in-flow-ref-with-try", new FlowExecutions("no-rollback-error-in-flow-ref-with-try", false, "commit", null)}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "no-rollback-error-in-flow-ref-with-try-join-tx", new FlowExecutions("no-rollback-error-in-flow-ref-with-try-join-tx", false, "commit", null)}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "with-implicit-default-EH-executed-commits", new FlowExecutions("with-implicit-default-EH-executed-commits", false, "commit", null)}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "with-implicit-default-EH-executed-rollback", new FlowExecutions("with-implicit-default-EH-executed-rollback", true, "rollback", null)}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "with-default-EH-executed-commits", new FlowExecutions("with-default-EH-executed-commits", false, "commit", null)}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "with-default-EH-executed-rollback", new FlowExecutions("with-default-EH-executed-rollback", false, "rollback", null)}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner-subflow.xml", "rollback-on-error-prop", new FlowExecutions("rollback-on-error-prop", false, "rollback", null)}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner-subflow.xml", "rollback-default-on-error-prop", new FlowExecutions("rollback-default-on-error-prop", true, "rollback", null)}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner-subflow.xml", "rollback-in-flow", new FlowExecutions("rollback-in-flow", true, "rollback", null)}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner-subflow.xml", "commit-flow-on-error-continue", new FlowExecutions("commit-flow-on-error-continue", false, "commit", null)}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner-subflow.xml", "rollback-nested-subflows", new FlowExecutions("rollback-nested-subflows", true, "rollback", null)}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner-subflow.xml", "commit-nested-subflows", new FlowExecutions("commit-nested-subflows", false, "commit", null)}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner-subflow.xml", "rollback-nested-flows", new FlowExecutions("rollback-nested-flows", true, "rollback", null)}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner-subflow.xml", "commit-nested-flows", new FlowExecutions("commit-nested-flows", false, "commit", null)}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "no-rollback", new FlowExecutions("no-rollback", false, "commit", null)}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "rollback", new FlowExecutions("rollback", false, "rollback", 1)}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "other-rollback", new FlowExecutions("other-rollback", true, "rollback", 1)}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "other-other-rollback", new FlowExecutions("other-other-rollback", true, "rollback", 2)}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "contained-flow-name", new FlowExecutions("contained-flow-name", true, "rollback", 2)}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "rollback-with-error-handler-reference-at-inner-transaction-location", new FlowExecutions("rollback-with-error-handler-reference-at-inner-transaction-location", true, "rollback", 1)}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "rollback-in-flowref", new FlowExecutions("rollback-in-flowref", true, "rollback", 1)}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "no-rollback-outside-try", new FlowExecutions("no-rollback-outside-try", true, "commit", null)}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "no-rollback-flowref", new FlowExecutions("no-rollback-flowref", false, "commit", null)}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "no-rollback-error-in-flowref", new FlowExecutions("no-rollback-error-in-flowref", false, "commit", null)}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "rollback-error-in-flowref-with-try", new FlowExecutions("rollback-error-in-flowref-with-try", true, "rollback", 3)}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "no-rollback-error-in-flowref-with-try", new FlowExecutions("no-rollback-error-in-flowref-with-try", false, "commit", null)}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "rollback-error-in-flowref-with-nested-try", new FlowExecutions("rollback-error-in-flowref-with-nested-try", false, "rollback", 3)}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "no-rollback-error-in-flowref-with-nested-try", new FlowExecutions("no-rollback-error-in-flowref-with-nested-try", false, "commit", null)}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "no-rollback-error-in-flowref-with-try-join-tx", new FlowExecutions("no-rollback-error-in-flowref-with-try-join-tx", false, "commit", null)}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "rollback-error-in-nested-try", new FlowExecutions("rollback-error-in-nested-try", true, "rollback", 1)}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "rollback-error-in-nested-try-with-same-error-handler", new FlowExecutions("rollback-error-in-nested-try-with-same-error-handler", true, "rollback", 2)}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-source-owner-global-err.xml", "rollback-error-in-nested-flow", new FlowExecutions("rollback-error-in-nested-flow", true, "rollback", 2, true)}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "rollback-error-in-flowref-with-try-3-levels", new FlowExecutions("rollback-error-in-flowref-with-try-3-levels", true, "rollback", 5)}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "rollback-error-in-flowref-with-try-4-levels", new FlowExecutions("rollback-error-in-flowref-with-try-4-levels", true, "rollback", 7)}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "rollback-error-start-tx-in-flowref-with-try-3-levels", new FlowExecutions("rollback-error-start-tx-in-flowref-with-try-3-levels", true, "rollback", 3)}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "no-rollback-second-execution", new FlowExecutions(new FlowExecution("commit-or-rollback-after-error", "commit", false, "commit", null), new FlowExecution("commit-or-rollback-after-error", "commit", false, "commit", null))}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "rollback-second-execution", new FlowExecutions(new FlowExecution("commit-or-rollback-after-error", "commit", false, "commit", null), new FlowExecution("commit-or-rollback-after-error", true, "rollback", 4))}, {"Default Error Handler", "org/mule/test/integration/transaction/transaction-owner-default-err.xml", "rollback", new FlowExecutions("rollback", true, "rollback", 1)}, {"Default Error Handler", "org/mule/test/integration/transaction/transaction-owner-default-err.xml", "other-rollback", new FlowExecutions("other-rollback", true, "rollback", 1)}, {"Default Error Handler", "org/mule/test/integration/transaction/transaction-owner-default-err.xml", "other-other-rollback", new FlowExecutions("other-other-rollback", true, "rollback", 3)}, {"Default Error Handler", "org/mule/test/integration/transaction/transaction-owner-default-err.xml", "contained-flow-name", new FlowExecutions("contained-flow-name", true, "rollback", 3)}, {"Default Error Handler", "org/mule/test/integration/transaction/transaction-owner-default-err.xml", "rollback-with-error-handler-reference-at-inner-transaction-location", new FlowExecutions("rollback-with-error-handler-reference-at-inner-transaction-location", true, "rollback", 1)}, {"Default Error Handler", "org/mule/test/integration/transaction/transaction-owner-default-err.xml", "rollback-in-flowref", new FlowExecutions("rollback-in-flowref", true, "rollback", 1)}, {"Default Error Handler", "org/mule/test/integration/transaction/transaction-owner-default-err.xml", "no-rollback-outside-try", new FlowExecutions("no-rollback-outside-try", true, "commit", null)}, {"Default Error Handler", "org/mule/test/integration/transaction/transaction-owner-default-err.xml", "rollback-error-in-flowref-with-try", new FlowExecutions("rollback-error-in-flowref-with-try", true, "rollback", 2)}, {"Default Error Handler", "org/mule/test/integration/transaction/transaction-owner-default-err.xml", "rollback-error-in-flowref-with-nested-try", new FlowExecutions("rollback-error-in-flowref-with-nested-try", false, "rollback", 2)}, {"Default Error Handler", "org/mule/test/integration/transaction/transaction-owner-default-err.xml", "no-rollback-error-in-flowref-with-nested-try", new FlowExecutions("no-rollback-error-in-flowref-with-nested-try", false, "commit", null)}, {"Default Error Handler", "org/mule/test/integration/transaction/transaction-owner-default-err.xml", "rollback-error-in-nested-try", new FlowExecutions("rollback-error-in-nested-try", true, "rollback", 1)}, {"Default Error Handler", "org/mule/test/integration/transaction/transaction-owner-default-err.xml", "rollback-error-in-nested-try-with-same-error-handler", new FlowExecutions("rollback-error-in-nested-try-with-same-error-handler", true, "rollback", 2)}, {"Default Error Handler", "org/mule/test/integration/transaction/transaction-owner-default-err.xml", "rollback-error-in-flowref-with-try-3-levels", new FlowExecutions("rollback-error-in-flowref-with-try-3-levels", true, "rollback", 4)}, {"Default Error Handler", "org/mule/test/integration/transaction/transaction-owner-default-err.xml", "rollback-error-in-flowref-with-try-4-levels", new FlowExecutions("rollback-error-in-flowref-with-try-4-levels", true, "rollback", 6)}, {"Default Error Handler", "org/mule/test/integration/transaction/transaction-owner-default-err.xml", "rollback-error-start-tx-in-flowref-with-try-3-levels", new FlowExecutions("rollback-error-start-tx-in-flowref-with-try-3-levels", true, "rollback", 2)}, {"Default Error Handler", "org/mule/test/integration/transaction/transaction-owner-default-err.xml", "no-rollback-second-execution", new FlowExecutions(new FlowExecution("commit-or-rollback-after-error", "commit", false, "commit", null), new FlowExecution("commit-or-rollback-after-error", "commit", false, "commit", null))}, {"Default Error Handler", "org/mule/test/integration/transaction/transaction-owner-default-err.xml", "rollback-second-execution", new FlowExecutions(new FlowExecution("commit-or-rollback-after-error", "commit", false, "commit", null), new FlowExecution("commit-or-rollback-after-error", true, "rollback", 4))}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "rollbackIfErrorDuringContinue", new FlowExecutions(new FlowExecution("rollbackIfErrorDuringContinue", true, "rollback", null))}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "rollbackIfErrorDuringContinueGlobalEH", new FlowExecutions(new FlowExecution("rollbackIfErrorDuringContinueGlobalEH", true, "rollback", null))}};
    }

    public TransactionRolledBackByOwnerTestCase(String type, String config, String testFlow, FlowExecutions flowExecutions) {
        this.config = config;
        this.flowExecutions = flowExecutions;
    }

    protected String getConfigFile() {
        return this.config;
    }

    protected void doSetUp() throws Exception {
        this.cleanStates();
        this.service.registerProfilingDataConsumer((ProfilingDataConsumer)new ProfilingDataConsumer<TransactionProfilingEventContext>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onProfilingEvent(ProfilingEventType<TransactionProfilingEventContext> profilingEventType, TransactionProfilingEventContext profilingEventContext) {
                Object object = TransactionRolledBackByOwnerTestCase.this.statesLock;
                synchronized (object) {
                    TransactionRolledBackByOwnerTestCase.this.states.add(profilingEventType.toString());
                    String originatingLocation = profilingEventContext.getEventOrginatingLocation().getLocation();
                    TransactionRolledBackByOwnerTestCase.this.statesPerLocation.computeIfAbsent(originatingLocation, k -> new ArrayList());
                    TransactionRolledBackByOwnerTestCase.this.statesPerLocation.get(originatingLocation).add(profilingEventType.toString());
                }
            }

            public Set<ProfilingEventType<TransactionProfilingEventContext>> getProfilingEventTypes() {
                HashSet<ProfilingEventType<TransactionProfilingEventContext>> events = new HashSet<ProfilingEventType<TransactionProfilingEventContext>>();
                events.add(RuntimeProfilingEventTypes.TX_START);
                events.add(RuntimeProfilingEventTypes.TX_COMMIT);
                events.add(RuntimeProfilingEventTypes.TX_CONTINUE);
                events.add(RuntimeProfilingEventTypes.TX_ROLLBACK);
                return events;
            }

            public Predicate<TransactionProfilingEventContext> getEventContextFilter() {
                return tx -> true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanStates() {
        Object object = this.statesLock;
        synchronized (object) {
            this.states = new ArrayList<String>();
            this.statesPerLocation = new HashMap<String, List<String>>();
        }
    }

    @Test
    public void checkRollback() {
        this.flowExecutions.forEach(flowExecution -> {
            block7: {
                this.cleanStates();
                try {
                    ((FlowRunner)this.flowRunner(flowExecution.flowName).withPayload(flowExecution.payload)).run();
                    if (flowExecution.throwsMessagingException) {
                        Assert.fail((String)"Should have thrown Exception from unhandled error");
                    }
                }
                catch (Exception e) {
                    if (flowExecution.throwsMessagingException) break block7;
                    Assert.fail((String)("Should have not thrown Exception from handled error: " + String.valueOf(e)));
                }
            }
            Object object = this.statesLock;
            synchronized (object) {
                this.assertStatesArrived();
                this.assertCorrectStates((FlowExecution)flowExecution);
                if (flowExecution.globalHandlerExecutionsBeforeRollback != null) {
                    this.assertTransactionRolledBackAtTheRightHandler((FlowExecution)flowExecution);
                }
            }
        });
    }

    private void assertStatesArrived() {
        PollingProber pollingProber = new PollingProber(5000L, 100L);
        pollingProber.check((Probe)new JUnitProbe(){

            protected boolean test() {
                MatcherAssert.assertThat((Object)TransactionRolledBackByOwnerTestCase.this.states.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
                return true;
            }

            public String describeFailure() {
                return "States did not arrive";
            }
        });
    }

    private void assertCorrectStates(FlowExecution flowExecution) {
        if (flowExecution.ignoreExtraStates) {
            List<String> filteredStates = this.states.stream().filter(state -> state.equals(flowExecution.expectedFinalState)).toList();
            MatcherAssert.assertThat((String)("Expected final state " + flowExecution.expectedFinalState + " to be received only once: " + String.valueOf(this.states)), filteredStates, (Matcher)Matchers.iterableWithSize((int)1));
        } else {
            MatcherAssert.assertThat((String)("Expected final state from " + String.valueOf(this.states) + " to be " + flowExecution.expectedFinalState), (Object)this.states.get(this.states.size() - 1), (Matcher)Matchers.is((Object)flowExecution.expectedFinalState));
        }
    }

    private void assertTransactionRolledBackAtTheRightHandler(FlowExecution flowExecution) {
        List<String> states = this.statesPerLocation.get("globalPropagate/0");
        String reason = "Expected 'globalPropagate' handler to be executed " + flowExecution.globalHandlerExecutionsBeforeRollback + " times, but it got executed with states %s";
        if (flowExecution.ignoreExtraStates) {
            states = states.subList(0, states.indexOf(flowExecution.expectedFinalState));
            MatcherAssert.assertThat((String)String.format(reason, states), states, (Matcher)Matchers.iterableWithSize((int)1));
        } else {
            MatcherAssert.assertThat((String)String.format(reason, states), states, (Matcher)Matchers.iterableWithSize((int)flowExecution.globalHandlerExecutionsBeforeRollback));
        }
    }

    private static class FlowExecutions {
        final List<FlowExecution> flowExecutions;

        public FlowExecutions(String flowName, boolean throwsMessagingException, String expectedFinalState, Integer globalHandlerExecutionsBeforeRollback) {
            this(flowName, throwsMessagingException, expectedFinalState, globalHandlerExecutionsBeforeRollback, false);
        }

        public FlowExecutions(String flowName, boolean throwsMessagingException, String expectedFinalState, Integer globalHandlerExecutionsBeforeRollback, boolean ignoreExtraStates) {
            this.flowExecutions = Collections.singletonList(new FlowExecution(flowName, throwsMessagingException, expectedFinalState, globalHandlerExecutionsBeforeRollback, ignoreExtraStates));
        }

        public FlowExecutions(FlowExecution ... flowExecutions) {
            this.flowExecutions = Arrays.asList(flowExecutions);
        }

        public void forEach(Consumer<FlowExecution> action) {
            this.flowExecutions.forEach(action);
        }
    }

    private static class FlowExecution {
        final String flowName;
        final Object payload;
        final boolean throwsMessagingException;
        final String expectedFinalState;
        final Integer globalHandlerExecutionsBeforeRollback;
        final boolean ignoreExtraStates;

        public FlowExecution(String flowName, boolean throwsMessagingException, String expectedFinalState, Integer globalHandlerExecutionsBeforeRollback) {
            this(flowName, throwsMessagingException, expectedFinalState, globalHandlerExecutionsBeforeRollback, false);
        }

        public FlowExecution(String flowName, boolean throwsMessagingException, String expectedFinalState, Integer globalHandlerExecutionsBeforeRollback, boolean ignoreExtraStates) {
            this(flowName, "message", throwsMessagingException, expectedFinalState, globalHandlerExecutionsBeforeRollback, ignoreExtraStates);
        }

        public FlowExecution(String flowName, Object payload, boolean throwsMessagingException, String expectedFinalState, Integer globalHandlerExecutionsBeforeRollback) {
            this(flowName, payload, throwsMessagingException, expectedFinalState, globalHandlerExecutionsBeforeRollback, false);
        }

        public FlowExecution(String flowName, Object payload, boolean throwsMessagingException, String expectedFinalState, Integer globalHandlerExecutionsBeforeRollback, boolean ignoreExtraStates) {
            this.flowName = flowName;
            this.payload = payload;
            this.throwsMessagingException = throwsMessagingException;
            this.expectedFinalState = expectedFinalState;
            this.globalHandlerExecutionsBeforeRollback = globalHandlerExecutionsBeforeRollback;
            this.ignoreExtraStates = ignoreExtraStates;
        }
    }
}

