/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.locator;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.test.AbstractIntegrationTestCase;

@Features(value={@Feature(value="Lazy Initialization"), @Feature(value="Expression Language")})
@Story(value="Support Functions")
public class LazyInitExpressionManagerTestCase
extends AbstractIntegrationTestCase {
    @Inject
    private LazyComponentInitializer lazyComponentInitializer;
    private static ClassLoader recordedTccl;

    protected String getConfigFile() {
        return "org/mule/test/integration/locator/lazy-expressions.xml";
    }

    public boolean enableLazyInit() {
        return true;
    }

    @Test
    @Issue(value="MULE-19468")
    @Description(value="Verify that lazyInit doesn't break the setting of the proper TCCL when calling DW.")
    public void callsWeaveFunctionFromReusableAppSuccess() throws Exception {
        this.lazyComponentInitializer.initializeComponent(Location.builderFromStringRepresentation((String)"callsWeaveFunctionFromReusableApp").build());
        this.flowRunner("callsWeaveFunctionFromReusableApp").run();
        MatcherAssert.assertThat((Object)recordedTccl, (Matcher)Matchers.sameInstance((Object)muleContext.getExecutionClassLoader()));
    }

    public static Object recordTccl(Object payload) {
        recordedTccl = Thread.currentThread().getContextClassLoader();
        return payload;
    }
}

