/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration;

import io.qameta.allure.Description;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;

public class PolicyCacheDisposalTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public DynamicPort listenPort = new DynamicPort("http.listener.port");
    @Inject
    @Named(value="_muleLazyComponentInitializer")
    private LazyComponentInitializer lazyComponentInitializer;

    protected String getConfigFile() {
        return "org/mule/test/integration/policy-cache-disposal-config.xml";
    }

    public boolean enableLazyInit() {
        return true;
    }

    @Description(value="Start and stop flow source")
    @Test
    public void policyCacheEntriesGetEvictedOnFlowDisposal() throws Exception {
        this.lazyComponentInitializer.initializeComponents(componentLocation -> componentLocation.getLocation().equals("listenerFlow") || componentLocation.getLocation().equals("hitFlow"));
        CoreEvent hitFlow = this.flowRunner("hitFlow").keepStreamsOpen().run();
        MatcherAssert.assertThat((Object)PolicyCacheDisposalTestCase.toString((CursorStreamProvider)hitFlow.getMessage().getPayload().getValue()), (Matcher)IsEqual.equalTo((Object)"Hello"));
        this.lazyComponentInitializer.initializeComponents(componentLocation -> componentLocation.getLocation().equals("listenerFlow") || componentLocation.getLocation().equals("hitFlow"));
        CoreEvent hitFlow2 = this.flowRunner("hitFlow").keepStreamsOpen().run();
        MatcherAssert.assertThat((Object)PolicyCacheDisposalTestCase.toString((CursorStreamProvider)hitFlow2.getMessage().getPayload().getValue()), (Matcher)IsEqual.equalTo((Object)"Hello"));
    }

    public static String toString(CursorStreamProvider cursorStreamProvider) {
        String string;
        block8: {
            InputStream input = (InputStream)cursorStreamProvider.openCursor();
            try {
                string = IOUtils.toString((InputStream)input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iox) {
                    throw new RuntimeException(iox);
                }
            }
            input.close();
        }
        return string;
    }
}

