/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import jakarta.inject.Inject;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.notification.ErrorHandlerNotification;
import org.mule.runtime.api.notification.ErrorHandlerNotificationListener;
import org.mule.runtime.api.notification.IntegerAction;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tests.api.TestQueueManager;

public class ExceptionListenerTestCase
extends AbstractIntegrationTestCase {
    private static final int TIMEOUT_MILLIS = 5000;
    private static final int POLL_DELAY_MILLIS = 100;
    @Inject
    private TestQueueManager queueManager;
    private ErrorHandlerNotification exceptionStrategyStartNotification;
    private ErrorHandlerNotification exceptionStrategyEndNotification;

    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/exception-listener-config-flow.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.exceptionStrategyStartNotification = null;
        this.exceptionStrategyEndNotification = null;
        muleContext.getNotificationManager().addListener((NotificationListener)new ErrorHandlerNotificationListener<ErrorHandlerNotification>(){

            public boolean isBlocking() {
                return false;
            }

            public void onNotification(ErrorHandlerNotification notification) {
                if (new IntegerAction(2001).equals((Object)notification.getAction())) {
                    ExceptionListenerTestCase.this.exceptionStrategyStartNotification = notification;
                } else if (new IntegerAction(2002).equals((Object)notification.getAction())) {
                    ExceptionListenerTestCase.this.exceptionStrategyEndNotification = notification;
                }
            }
        });
    }

    @Test
    public void testExceptionStrategyFromComponent() throws Exception {
        this.assertQueueIsEmpty("error.queue");
        ((FlowRunner)this.flowRunner("mycomponent").withPayload((Object)"test")).dispatch();
        this.assertQueueIsEmpty("component.out");
        Message message = this.queueManager.read("error.queue", 2000L, TimeUnit.MILLISECONDS).getMessage();
        Assert.assertNotNull((Object)message);
        Object payload = message.getPayload().getValue();
        MatcherAssert.assertThat((Object)payload, (Matcher)CoreMatchers.is((Object)"test"));
        this.assertNotificationsArrived();
        this.assertNotificationsHaveMatchingResourceIds();
    }

    private void assertNotificationsHaveMatchingResourceIds() {
        MatcherAssert.assertThat((Object)this.exceptionStrategyStartNotification.getResourceIdentifier(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        MatcherAssert.assertThat((Object)this.exceptionStrategyStartNotification.getResourceIdentifier(), (Matcher)CoreMatchers.is((Object)"mycomponent"));
        MatcherAssert.assertThat((Object)this.exceptionStrategyStartNotification.getResourceIdentifier(), (Matcher)CoreMatchers.is((Object)this.exceptionStrategyEndNotification.getResourceIdentifier()));
    }

    private void assertNotificationsArrived() {
        PollingProber prober = new PollingProber(5000L, 100L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                MatcherAssert.assertThat((Object)ExceptionListenerTestCase.this.exceptionStrategyStartNotification, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
                MatcherAssert.assertThat((Object)ExceptionListenerTestCase.this.exceptionStrategyEndNotification, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
                return true;
            }

            public String describeFailure() {
                return "Did not get exception strategy notifications";
            }
        });
    }

    private void assertQueueIsEmpty(String queueName) throws MuleException {
        MatcherAssert.assertThat((Object)this.queueManager.read(queueName, 2000L, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

