/*
 * Decompiled with CFR 0.152.
 */
package org.mule.http.response;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collection;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="HTTP Service")
@Story(value="Response Builder")
public class HttpResponseBuilderTestCase
extends AbstractMuleTestCase {
    private HttpResponseBuilder builder = HttpResponse.builder();
    private String header = "HEADER";
    private String value = "value";

    @Test
    public void defaultResponse() {
        HttpResponse response = this.builder.build();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)response.getReasonPhrase(), (Matcher)Matchers.isEmptyString());
        Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(EmptyHttpEntity.class)));
        Assert.assertThat((Object)response.getHeaderNames(), (Matcher)Matchers.empty());
    }

    @Test
    public void complexResponse() {
        HttpResponse response = ((HttpResponseBuilder)((HttpResponseBuilder)this.builder.entity((HttpEntity)new ByteArrayHttpEntity("test".getBytes()))).statusCode(Integer.valueOf(418)).reasonPhrase("I'm a teapot").addHeader(this.header, this.value)).build();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)418));
        Assert.assertThat((Object)response.getReasonPhrase(), (Matcher)Matchers.is((Object)"I'm a teapot"));
        Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(ByteArrayHttpEntity.class)));
        Assert.assertThat((Object)response.getHeaderNames(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.equalToIgnoringCase((String)this.header)}));
        Assert.assertThat((Object)response.getHeaderValuesIgnoreCase(this.header), (Matcher)Matchers.hasItems((Object[])new String[]{this.value}));
    }

    @Test
    public void headerManipulation() {
        Assert.assertThat((Object)this.builder.build().getHeaderNames(), (Matcher)Matchers.empty());
        this.builder.addHeader(this.header, this.value);
        Optional headerValue = this.builder.getHeaderValue(this.header);
        Assert.assertThat((Object)headerValue.isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((String)headerValue.get()), (Matcher)Matchers.is((Object)this.value));
        Collection headerValues = this.builder.getHeaderValues(this.header);
        Assert.assertThat((Object)headerValues, (Matcher)Matchers.hasItems((Object[])new String[]{this.value}));
        Assert.assertThat((Object)this.builder.build().getHeaderValuesIgnoreCase(this.header), (Matcher)Matchers.hasItems((Object[])new String[]{this.value}));
        this.builder.addHeader(this.header.toLowerCase(), this.value.toUpperCase());
        Optional headerValue2 = this.builder.getHeaderValue(this.header);
        Assert.assertThat((Object)headerValue2.isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((String)headerValue2.get()), (Matcher)Matchers.is((Object)this.value));
        Collection headerValues2 = this.builder.getHeaderValues(this.header.toLowerCase());
        Assert.assertThat((Object)headerValues2, (Matcher)Matchers.hasItems((Object[])new String[]{this.value, this.value.toUpperCase()}));
        Assert.assertThat((Object)this.builder.build().getHeaderValuesIgnoreCase(this.header), (Matcher)Matchers.hasItems((Object[])new String[]{this.value, this.value.toUpperCase()}));
        this.builder.removeHeader(this.header);
        Assert.assertThat((Object)this.builder.build().getHeaderNames(), (Matcher)Matchers.empty());
    }

    @Test
    public void headerCheck() {
        HttpResponse response = ((HttpResponseBuilder)this.builder.addHeader(this.header, this.value)).build();
        Assert.assertThat((Object)response.containsHeader(this.header), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)response.containsHeader("wat"), (Matcher)Matchers.is((Object)false));
    }
}

