/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tls.crl.server;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.mule.extension.http.api.error.HttpRequestFailedException;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tls.crl.AbstractHttpTlsRevocationTestCase;
import org.mule.tls.fips.DefaultTestConfiguration;

public abstract class AbstractHttpListenerClrTestCase
extends AbstractHttpTlsRevocationTestCase {
    @Rule
    public SystemProperty trustStoreType = new SystemProperty("trustStoreType", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTrustStoreJCEKSType());
    @Rule
    public SystemProperty keyStoreType = new SystemProperty("keyStoreType", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getKeyStorePKS12Type());
    @Rule
    public SystemProperty password = new SystemProperty("password", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().resolveStorePassword("test"));
    @Rule
    public SystemProperty entity1KeyStore = new SystemProperty("entity1KeyStore", this.getEntity1KeyStore());
    @Rule
    public SystemProperty getCertificateAuthorityEntityPath = new SystemProperty("certificateAuthorityEntity", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getCertificateAuthorityEntity());
    @Rule
    public SystemProperty trustStore = new SystemProperty("trustStore", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTrustFileForCrl());

    AbstractHttpListenerClrTestCase(String crlPath, String entityCertified) {
        super("http-listener-tls-revocation-file-config.xml", crlPath, entityCertified);
    }

    void verifyRemotelyClosedCause(Exception e) {
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(HttpRequestFailedException.class));
        MatcherAssert.assertThat((Object)e.getCause().getMessage(), (Matcher)CoreMatchers.containsString((String)"Remotely closed"));
    }

    private String getEntity1KeyStore() {
        if (DefaultTestConfiguration.isFipsTesting()) {
            return "tls/crl/entity1-fips.bcfks";
        }
        return "tls/crl/entity1";
    }
}

