/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tls;

import io.qameta.allure.Feature;
import java.net.HttpURLConnection;
import java.net.URL;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.CombinableMatcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.StringContains;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.functional.junit4.matchers.MessageMatchers;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tls.fips.DefaultTestConfiguration;

@Feature(value="TLS/SSL")
public class HttpStandardRevocationConfigTestCase
extends AbstractIntegrationTestCase {
    protected String getConfigFile() {
        return "http-requester-standard-revocation-config.xml";
    }

    @BeforeClass
    public static void before() {
        Assume.assumeFalse((String)"W-16968647: Check that this is not in fips where the standard revocation check does not work. Another of the documented options should be used", (boolean)DefaultTestConfiguration.isFipsTesting());
    }

    @Before
    public void setup() {
        Boolean reachable = false;
        try {
            URL url = new URL("http://www.google.com/");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            if (conn.getResponseCode() == 200) {
                reachable = true;
                conn.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assume.assumeTrue((String)"Check for internet connection, and access to www.google.com", (boolean)reachable);
    }

    @Test
    public void revocationWorksWithoutTrustStore() throws Exception {
        CoreEvent event = this.flowRunner("test").keepStreamsOpen().run();
        MatcherAssert.assertThat((Object)((HttpResponseAttributes)event.getMessage().getAttributes().getValue()).getStatusCode(), (Matcher)Is.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        MatcherAssert.assertThat((Object)event.getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)CombinableMatcher.both((Matcher)StringContains.containsString((String)"test")).and(StringContains.containsStringIgnoringCase((String)"google"))));
    }
}

