/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.test.integration.exceptions;

import static org.mule.tck.junit4.matcher.ErrorTypeMatcher.errorType;
import static org.mule.test.allure.AllureConstants.ErrorHandlingFeature.ERROR_HANDLING;
import static org.mule.test.allure.AllureConstants.ErrorHandlingFeature.ErrorHandlingStory.ERROR_HANDLER;
import static org.mule.test.allure.AllureConstants.ErrorHandlingFeature.ErrorHandlingStory.ERROR_MAPPINGS;

import static org.apache.commons.lang3.JavaVersion.JAVA_20;
import static org.apache.commons.lang3.SystemUtils.isJavaVersionAtMost;

import static org.junit.Assume.assumeTrue;

import org.mule.test.AbstractIntegrationTestCase;

import org.junit.Test;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;

@Feature(ERROR_HANDLING)
@Story(ERROR_HANDLER)
@Story(ERROR_MAPPINGS)
public class ValidationModuleErrorHandlingTestCase extends AbstractIntegrationTestCase {

  @Override
  protected String getConfigFile() {
    return "org/mule/test/integration/exceptions/validation-module-error-handling.xml";
  }

  @Test
  @Issue("MULE-19139")
  public void validationAllWithErrorMapping() throws Exception {
    // TODO TD-0269910 Remove this assumption
    assumeTrue(isJavaVersionAtMost(JAVA_20));

    flowRunner("validationAllWithErrorMapping").runExpectingException(errorType("APP", "NULL"));
  }

  @Test
  @Issue("MULE-19139")
  public void validationWithErrorMapping() throws Exception {
    flowRunner("validationWithErrorMapping").runExpectingException(errorType("APP", "NULL"));
  }

}
