/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tls;

import io.qameta.allure.Feature;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.runners.Parameterized;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.runner.RunnerDelegateTo;
import org.mule.tls.fips.DefaultTestConfiguration;

@Feature(value="TLS/SSL")
@RunnerDelegateTo(value=Parameterized.class)
public class HttpRequestTlsInsecureTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public SystemProperty serverKeyStore = new SystemProperty("serverKeyStore", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestServerKeyStore());
    @Rule
    public SystemProperty password = new SystemProperty("password", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestStorePassword());
    @Rule
    public SystemProperty storeType = new SystemProperty("storeType", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestStoreType());
    @Rule
    public SystemProperty sslCacerts = new SystemProperty("sslCacerts", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestSslCaCerts());
    @Rule
    public SystemProperty sslKeyStoreWithTestHostname = new SystemProperty("sslKeyStoreWithTestHostname", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestSslKeyStoreWithHostName());
    @Parameterized.Parameter
    public String config;
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");
    @Rule
    public SystemProperty insecure = new SystemProperty("insecure", "true");
    @Rule
    public ExpectedError expectedError = ExpectedError.none();

    protected String getConfigFile() {
        return this.config;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"http-request-insecure-hostname-config.xml"}, {"http-request-insecure-certificate-config.xml"});
    }

    @Test
    public void insecureRequest() throws Exception {
        CoreEvent res = ((FlowRunner)this.flowRunner("testInsecureRequest").withPayload((Object)"test")).run();
        MatcherAssert.assertThat((Object)res.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
    }

    @Test
    public void secureRequest() throws Exception {
        this.expectedError.expectCause(CoreMatchers.instanceOf(IOException.class));
        this.expectedError.expectCause((Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"General SSLEngine problem")), ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"No trusted certificate found")), ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"PKIX path building failed")), ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"certificate_unknown"))}));
        ((FlowRunner)this.flowRunner("testSecureRequest").withPayload((Object)"test")).run();
    }
}

