/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.context.notification;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.runners.Parameterized;
import org.mule.test.config.spring.parsers.AbstractBadConfigTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class NotificationTypesTestCase
extends AbstractBadConfigTestCase {
    private Matcher<String> parseConfigErrorMessageMatcher;
    private String configFile;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"org/mule/test/context/notification/mule-config-inexistent-notification.xml", Matchers.containsString((String)"No notification 'nothing:I-DONT-EXIST' declared in this applications plugins to enable.")}, {"org/mule/test/context/notification/mule-config-disable-inexistent-notification.xml", Matchers.containsString((String)"No notification 'nothing:I-DONT-EXIST' declared in this applications plugins to disable.")}, {"org/mule/test/context/notification/mule-config-invalid-notification.xml", Matchers.containsString((String)"'1234' is not a valid value of union type 'notificationTypes'")}, {"org/mule/test/context/notification/mule-config-disable-invalid-notification.xml", Matchers.containsString((String)"'1234' is not a valid value of union type 'notificationTypes'")});
    }

    public NotificationTypesTestCase(String configFile, Matcher<String> parseConfigErrorMessageMatcher) {
        this.configFile = configFile;
        this.parseConfigErrorMessageMatcher = parseConfigErrorMessageMatcher;
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Test
    public void failingNotificationType() {
        Exception thrown = (Exception)Assertions.assertThrows(Exception.class, () -> this.parseConfig());
        MatcherAssert.assertThat((Object)thrown.getMessage(), this.parseConfigErrorMessageMatcher);
    }
}

