/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.construct;

import jakarta.inject.Inject;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.api.flow.TransactionConfigEnum;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tests.api.TestQueueManager;

public class FlowDefaultProcessingStrategyTestCase
extends AbstractIntegrationTestCase {
    private static final String FLOW_NAME = "Flow";
    @Inject
    private TestQueueManager queueManager;

    protected String getConfigFile() {
        return "org/mule/test/construct/flow-default-processing-strategy-config.xml";
    }

    @Test
    public void requestResponse() throws Exception {
        ((FlowRunner)this.flowRunner(FLOW_NAME).withPayload((Object)"test")).run();
        Message message = this.queueManager.read("out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        MatcherAssert.assertThat((Object)message.getPayload().getValue(), (Matcher)Matchers.is((Matcher)Matchers.not((Object)Thread.currentThread().getName())));
    }

    @Test
    public void oneWay() throws Exception {
        ((FlowRunner)this.flowRunner(FLOW_NAME).withPayload((Object)"test")).run();
        Message message = this.queueManager.read("out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        MatcherAssert.assertThat((Object)message.getPayload().getValue(), (Matcher)Matchers.is((Matcher)Matchers.not((Object)Thread.currentThread().getName())));
    }

    @Test
    public void requestResponseTransacted() throws Exception {
        Transaction transaction = this.createTransactionMock();
        try {
            ((FlowRunner)this.flowRunner(FLOW_NAME).withPayload((Object)"test")).transactionally(TransactionConfigEnum.ACTION_ALWAYS_BEGIN, transaction).run();
            Message message = this.queueManager.read("out", 5000L, TimeUnit.MILLISECONDS).getMessage();
            MatcherAssert.assertThat((Object)message.getPayload().getValue(), (Matcher)Matchers.is((Object)Thread.currentThread().getName()));
        }
        finally {
            TransactionCoordination.getInstance().unbindTransaction(transaction);
        }
    }

    @Test
    public void oneWayTransacted() throws Exception {
        Transaction transaction = this.createTransactionMock();
        try {
            ((FlowRunner)this.flowRunner(FLOW_NAME).withPayload((Object)"test")).transactionally(TransactionConfigEnum.ACTION_ALWAYS_BEGIN, transaction).run();
            Message message = this.queueManager.read("out", 5000L, TimeUnit.MILLISECONDS).getMessage();
            MatcherAssert.assertThat((Object)message.getPayload().getValue(), (Matcher)Matchers.is((Object)Thread.currentThread().getName()));
        }
        finally {
            TransactionCoordination.getInstance().unbindTransaction(transaction);
        }
    }

    private Transaction createTransactionMock() throws TransactionException {
        Transaction transaction = (Transaction)Mockito.mock(Transaction.class);
        ((Transaction)Mockito.doAnswer(invocationOnMock -> {
            TransactionCoordination.getInstance().bindTransaction(transaction);
            return null;
        }).when((Object)transaction)).begin();
        return transaction;
    }

    public static class ThreadSensingMessageProcessor
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            return CoreEvent.builder((CoreEvent)event).message(Message.builder((Message)event.getMessage()).payload(new TypedValue((Object)Thread.currentThread().getName(), DataType.STRING)).build()).build();
        }
    }
}

