/*
 * Decompiled with CFR 0.152.
 */
package org.mule.http;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.test.util.tck.MultiMapTestCase;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;

@Feature(value="HTTP Service")
@Story(value="Multi Map")
public class CaseInsensitiveMultiMapTestCase
extends MultiMapTestCase {
    public CaseInsensitiveMultiMapTestCase(Supplier<MultiMap<String, String>> mapSupplier, Function<MultiMap<String, String>, MultiMap<String, String>> mapCopier) {
        super(mapSupplier, mapCopier);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{{() -> new CaseInsensitiveMultiMap(new MultiMap()), CaseInsensitiveMultiMap::new}});
    }

    @Test
    public void takesParamMapEntries() {
        MultiMap sensitiveMultiMap = new MultiMap();
        sensitiveMultiMap.put((Object)"key1", (Object)"value1");
        sensitiveMultiMap.put((Object)"key2", (Object)"value1");
        sensitiveMultiMap.put((Object)"key2", (Object)"value2");
        CaseInsensitiveMultiMap insensitiveMultiMap = new CaseInsensitiveMultiMap(sensitiveMultiMap);
        Assert.assertThat((Object)((String)insensitiveMultiMap.get((Object)"key1")), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)((String)insensitiveMultiMap.get((Object)"key1".toLowerCase())), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)((String)insensitiveMultiMap.get((Object)"key2")), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)((String)insensitiveMultiMap.get((Object)"key2".toLowerCase())), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)insensitiveMultiMap.getAll((Object)"key1"), (Matcher)Is.is(Arrays.asList("value1")));
        Assert.assertThat((Object)insensitiveMultiMap.getAll((Object)"key1".toLowerCase()), (Matcher)Is.is(Arrays.asList("value1")));
        Assert.assertThat((Object)insensitiveMultiMap.getAll((Object)"key2"), (Matcher)Is.is(Arrays.asList("value1", "value2")));
        Assert.assertThat((Object)insensitiveMultiMap.getAll((Object)"key2".toLowerCase()), (Matcher)Is.is(Arrays.asList("value1", "value2")));
    }

    @Test
    public void putAndGetCase() {
        Assert.assertThat((Object)((String)this.multiMap.put((Object)"kEy", (Object)"value1")), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)((String)this.multiMap.get((Object)"KeY")), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)((String)this.multiMap.get((Object)"kEy")), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)this.multiMap.getAll((Object)"key"), (Matcher)Is.is(Arrays.asList("value1")));
        Assert.assertThat((Object)this.multiMap.getAll((Object)"KEY"), (Matcher)Is.is(Arrays.asList("value1")));
    }

    @Test
    public void aggregatesSameCaseKeys() {
        Assert.assertThat((Object)((String)this.multiMap.put((Object)"kEy", (Object)"value1")), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)((String)this.multiMap.put((Object)"KeY", (Object)"value2")), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)((String)this.multiMap.get((Object)"key")), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)this.multiMap.getAll((Object)"KEY"), (Matcher)Is.is(Arrays.asList("value1", "value2")));
    }

    @Test
    public void immutableRemainsCaseInsensitive() {
        this.multiMap.put((Object)"wHaTeVeR", (Object)"value1");
        Assert.assertThat((Object)((String)this.multiMap.toImmutableMultiMap().get((Object)"Whatever")), (Matcher)Is.is((Object)"value1"));
    }

    @Test
    public void unmodifiableRemainsCaseInsensitive() {
        this.multiMap.put((Object)"wHaTeVeR", (Object)"value1");
        Assert.assertThat((Object)((String)MultiMap.unmodifiableMultiMap((MultiMap)this.multiMap).get((Object)"Whatever")), (Matcher)Is.is((Object)"value1"));
    }

    @Test
    public void emptyEquality() {
        CaseInsensitiveMultiMap otherMultiMap = new CaseInsensitiveMultiMap();
        Assert.assertThat((Object)this.multiMap, (Matcher)Is.is((Matcher)Matchers.equalTo((Object)otherMultiMap)));
        Assert.assertThat((Object)otherMultiMap, (Matcher)Is.is((Matcher)Matchers.equalTo((Object)this.multiMap)));
    }

    @Test
    public void complexEquality() {
        CaseInsensitiveMultiMap otherMultiMap = new CaseInsensitiveMultiMap();
        otherMultiMap.put((Object)"hello", (Object)"there");
        this.multiMap.put((Object)"hello", (Object)"there");
        otherMultiMap.put((Object)"hello", (Object)"stranger");
        this.multiMap.put((Object)"HellO", (Object)"stranger");
        otherMultiMap.put((Object)"bye", (Object)"dude");
        this.multiMap.put((Object)"BYE", (Object)"dude");
        Assert.assertThat((Object)otherMultiMap, (Matcher)Is.is((Matcher)Matchers.equalTo((Object)this.multiMap)));
        Assert.assertThat((Object)this.multiMap, (Matcher)Is.is((Matcher)Matchers.equalTo((Object)otherMultiMap)));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void immutableCaseInsensitiveMultiMapFailsOnPut() {
        this.multiMap.toImmutableMultiMap().put((Object)"key1", (Object)"value1");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void immutableCaseInsensitiveMultiMapFailsOnPutAll() {
        CaseInsensitiveMultiMap map = new CaseInsensitiveMultiMap();
        map.put((Object)"key1", (Object)"value1");
        this.multiMap.toImmutableMultiMap().putAll((MultiMap)map);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void immutableCaseInsensitiveMultiMapFailsOnRemove() {
        this.multiMap.toImmutableMultiMap().remove((Object)"key1");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void immutableCaseInsensitiveMultiMapFailsOnClear() {
        this.multiMap.toImmutableMultiMap().clear();
    }

    @Test
    public void toImmutableCaseInsensitiveMapKeepsOrder() {
        this.multiMap.put((Object)"key3", (Object)"value1");
        this.multiMap.put((Object)"key2", (Object)"value1");
        this.multiMap.put((Object)"key1", (Object)"value1");
        List entryList = this.multiMap.entryList();
        List immutableEntryList = this.multiMap.toImmutableMultiMap().entryList();
        Assert.assertEquals((Object)entryList, (Object)immutableEntryList);
    }
}

