/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tests.api.TestQueueManager;

@Feature(value="Scope")
@Story(value="Async")
public class AsyncTestCase
extends AbstractIntegrationTestCase {
    private static final int MAX_CONCURRENCY = 2;
    @Inject
    private TestQueueManager queueManager;
    @Rule
    public DynamicPort port = new DynamicPort("http.port");
    @Rule
    public SystemProperty maxConcurrency = new SystemProperty("maxConcurrency", "2");
    private CountDownLatch terminationLatch;
    @Inject
    @Named(value="with-max-concurrency")
    private FlowConstruct withMaxConcurrency;

    protected String getConfigFile() {
        return "org/mule/test/routing/async-test.xml";
    }

    @After
    public void after() throws InterruptedException {
        if (this.terminationLatch != null) {
            this.terminationLatch.await();
        }
    }

    @Test
    @Description(value="Assert that components in an async run in the correct thread according to the flow's PS")
    public void psThreadingPropagated() throws Exception {
        this.terminationLatch = new CountDownLatch(1);
        FlowRunner runner = this.flowRunner("ps-threading-propagated");
        ((BaseEventContext)runner.buildEvent().getContext()).onTerminated((e, t) -> this.terminationLatch.countDown());
        runner.run();
        CoreEvent afterAsyncMessage = this.queueManager.read("asyncFinished", 1000L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)afterAsyncMessage, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)afterAsyncMessage.getMessage().getPayload().getValue().toString(), (Matcher)Matchers.startsWith((String)"[MuleRuntime].uber."));
    }

    @Test
    @Stories(value={@Story(value="Backpressure"), @Story(value="Max concurrency")})
    @Description(value="Assert that async maxConcurrency is honored")
    public void withMaxConcurrency() throws Exception {
        this.testAsyncMaxConcurrency("with-max-concurrency");
    }

    @Test
    @Story(value="Backpressure")
    @Description(value="Assert that even if async is full, the calling flow continues executing")
    public void withMaxConcurrencyAsyncDispatched() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.runFlows("with-max-concurrency", latch);
        for (int i = 0; i < 3; ++i) {
            MatcherAssert.assertThat((String)("" + i), (Object)this.queueManager.read("asyncDispatched", 1000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        }
        latch.countDown();
    }

    @Test
    @Stories(value={@Story(value="Backpressure"), @Story(value="Max concurrency")})
    @Description(value="Assert that if no maxConcurrency is configured for an async, the value from the flow is inherited")
    public void withFlowMaxConcurrency() throws Exception {
        this.testAsyncMaxConcurrency("with-flow-max-concurrency");
    }

    @Test
    @Stories(value={@Story(value="Backpressure"), @Story(value="Max concurrency")})
    @Description(value="Assert that if both flow and async have maxConcurrency, they are independent")
    public void withLowerFlowMaxConcurrency() throws Exception {
        this.testAsyncMaxConcurrency("with-lower-flow-max-concurrency");
    }

    @Test
    @Story(value="Local Transaction")
    @Description(value="Assert that async blocks run outside of the transaction from the caller flow")
    public void withSourceTx() throws Exception {
        this.terminationLatch = new CountDownLatch(0);
        Startable withSourceTx = (Startable)this.locator.find(Location.builderFromStringRepresentation((String)"with-source-tx").build()).get();
        withSourceTx.start();
        MatcherAssert.assertThat((Object)this.queueManager.read("asyncDispatched", 5000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)this.queueManager.read("asyncRunning", 1000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
    }

    @Test
    @Story(value="Local Transaction")
    @Description(value="Assert that async blocks run outside of the transaction from the `try` in the caller flow")
    public void withTryTx() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.runFlows("with-try-tx", latch);
        MatcherAssert.assertThat((Object)this.queueManager.read("asyncDispatched", 1000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)this.queueManager.read("asyncRunning", 1000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        latch.countDown();
    }

    @Test
    @Story(value="Local Transaction")
    @Description(value="Assert that txs within async blocks are honored")
    public void txWithinAsync() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.runFlows("tx-within-async", latch);
        MatcherAssert.assertThat((Object)this.queueManager.read("asyncDispatched", 1000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)this.queueManager.read("asyncRunning", 1000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        latch.countDown();
    }

    @Test
    @Description(value="Assert that a combination of sub-flow, async, and try works as expected")
    public void tryNoTxWithinAsyncSubFlow() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.runFlows("tryNoTx-within-async-subFlow", latch);
        MatcherAssert.assertThat((Object)this.queueManager.read("asyncDispatched", 1000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)this.queueManager.read("asyncRunning", 1000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        latch.countDown();
    }

    @Test
    @Issue(value="MULE-17048")
    @Story(value="Graceful shutdown")
    public void flowStoppedWhileAsyncInFlight() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        ((FlowRunner)((FlowRunner)this.flowRunner("with-max-concurrency").withPayload((Object)"")).withVariable("latch", (Object)latch)).run();
        MatcherAssert.assertThat((Object)this.queueManager.read("asyncRunning", 1000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        LifecycleUtils.stopIfNeeded((Object)this.withMaxConcurrency);
        MatcherAssert.assertThat((Object)this.queueManager.read("asyncFinished", 1000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.nullValue());
        LifecycleUtils.startIfNeeded((Object)this.withMaxConcurrency);
    }

    @Test
    @Issue(value="MULE-18304")
    @Description(value="Verify that operations inner fluxes are not terminated when within async/sub-flow combination.")
    public void asyncFlowWithSdkOperation() throws Exception {
        this.flowRunner("asyncFlowWithSdkOperation").run();
        MatcherAssert.assertThat((Object)this.queueManager.read("asyncFinished", 1000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        this.flowRunner("asyncFlowWithSdkOperation").run();
        MatcherAssert.assertThat((Object)this.queueManager.read("asyncFinished", 1000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
    }

    @Test
    @Issue(value="MULE-18304")
    @Description(value="Verify that operations inner fluxes are not terminated when within error-handler/async/sub-flow combination.")
    public void asyncFlowWithSdkOperationInErrorHandler() throws Exception {
        this.flowRunner("asyncFlowWithSdkOperationInErrorHandler").runExpectingException();
        MatcherAssert.assertThat((Object)this.queueManager.read("asyncFinished", 1000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        this.flowRunner("asyncFlowWithSdkOperationInErrorHandler").runExpectingException();
        MatcherAssert.assertThat((Object)this.queueManager.read("asyncFinished", 1000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
    }

    @Test
    @Issue(value="MULE-19091")
    @Description(value="Verify that operations inner fluxes are not terminated when within error-handler/async/sub-flow combination.")
    public void asyncFlowWithSdkOperationInRefErrorHandler() throws Exception {
        this.flowRunner("asyncFlowWithSdkOperationInRefErrorHandler").runExpectingException();
        MatcherAssert.assertThat((Object)this.queueManager.read("asyncFinished", 1000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        this.flowRunner("asyncFlowWithSdkOperationInRefErrorHandler").runExpectingException();
        MatcherAssert.assertThat((Object)this.queueManager.read("asyncFinished", 1000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
    }

    private void testAsyncMaxConcurrency(String flowName) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.runFlows(flowName, latch);
        for (int i = 0; i < 2; ++i) {
            MatcherAssert.assertThat((String)("" + i), (Object)this.queueManager.read("asyncRunning", 1000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        }
        MatcherAssert.assertThat((Object)this.queueManager.read("asyncRunning", 1000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.nullValue());
        latch.countDown();
        MatcherAssert.assertThat((Object)this.queueManager.read("asyncRunning", 1000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
    }

    private void runFlows(String flowName, CountDownLatch latch) throws Exception {
        this.terminationLatch = new CountDownLatch(3);
        for (int i = 0; i < 3; ++i) {
            FlowRunner runner = (FlowRunner)((FlowRunner)this.flowRunner(flowName).withPayload((Object)i)).withVariable("latch", (Object)latch);
            ((BaseEventContext)runner.buildEvent().getContext()).onTerminated((e, t) -> this.terminationLatch.countDown());
            runner.run();
        }
    }

    protected boolean isGracefulShutdown() {
        return true;
    }
}

