/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.kerberos;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.kerby.kerberos.kerb.server.SimpleKdcServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosTestInfrastructure {
    private static final Logger LOGGER = LoggerFactory.getLogger(KerberosTestInfrastructure.class);
    public static final String DEFAULT_TEST_REALM = "TESTREALM";
    public static final String DEFAULT_CLIENT_PRINCIPAL = "testuser";
    public static final String DEFAULT_SERVICE_HOST = "localhost";
    public static final String DEFAULT_FULL_CLIENT_PRINCIPAL = "testuser@TESTREALM";
    private final String testRealm;
    private final String clientPrincipal;
    private final String serviceHost;
    private final String fullClientPrincipal;
    private SimpleKdcServer kdcServer;
    private WireMockServer mockServer;
    private File kdcWorkDir;
    private File clientKeytab;
    private String originalKrb5ConfProperty;
    private String originalJaasConfigProperty;

    public KerberosTestInfrastructure() {
        this.testRealm = DEFAULT_TEST_REALM;
        this.clientPrincipal = DEFAULT_CLIENT_PRINCIPAL;
        this.serviceHost = DEFAULT_SERVICE_HOST;
        this.fullClientPrincipal = DEFAULT_FULL_CLIENT_PRINCIPAL;
    }

    public void start() throws Exception {
        this.setupKdcServer();
        this.setupMockServer();
        this.createKrb5ConfigFile();
        LOGGER.info("Kerberos infrastructure ready - KDC: {}, WireMock: {}", (Object)this.kdcServer.getKdcPort(), (Object)this.mockServer.port());
    }

    public void stop() throws Exception {
        if (this.mockServer != null && this.mockServer.isRunning()) {
            this.mockServer.stop();
        }
        if (this.kdcServer != null) {
            try {
                this.kdcServer.stop();
            }
            catch (Exception e) {
                LOGGER.warn("Error stopping KDC server: {}", (Object)e.getMessage());
            }
        }
        this.cleanupFiles();
        this.restoreSystemProperties();
    }

    private void setupKdcServer() throws Exception {
        this.kdcWorkDir = new File("target/kdc-work-dir");
        if (!this.kdcWorkDir.mkdirs() && !this.kdcWorkDir.exists()) {
            throw new RuntimeException("Failed to create KDC work directory: " + this.kdcWorkDir.getAbsolutePath());
        }
        this.kdcServer = new SimpleKdcServer();
        this.kdcServer.setWorkDir(this.kdcWorkDir);
        this.kdcServer.setKdcRealm(this.testRealm);
        this.kdcServer.setKdcHost(this.serviceHost);
        this.kdcServer.setAllowUdp(true);
        this.kdcServer.setAllowTcp(true);
        this.kdcServer.init();
        this.kdcServer.start();
        this.kdcServer.createPrincipal(this.fullClientPrincipal, "password");
        String proxyHost = this.serviceHost;
        String fullServicePrincipal = "HTTP/" + proxyHost + "/" + this.testRealm.toLowerCase() + "@" + this.testRealm;
        this.kdcServer.createPrincipal(fullServicePrincipal, "service-password");
        File serviceKeytab = new File(this.kdcWorkDir, "service.keytab");
        this.kdcServer.exportPrincipal(fullServicePrincipal, serviceKeytab);
        this.clientKeytab = new File(this.kdcWorkDir, "client.keytab");
        this.kdcServer.exportPrincipal(this.fullClientPrincipal, this.clientKeytab);
        LOGGER.info("KDC server started on port {}", (Object)this.kdcServer.getKdcPort());
    }

    private void setupMockServer() {
        this.mockServer = new WireMockServer((Options)WireMockConfiguration.options().port(0).asynchronousResponseEnabled(true).asynchronousResponseThreads(10));
        this.mockServer.start();
        WireMock.configureFor((String)DEFAULT_SERVICE_HOST, (int)this.mockServer.port());
    }

    private void createKrb5ConfigFile() throws IOException {
        File targetDir = new File("target");
        if (!targetDir.mkdirs() && !targetDir.exists()) {
            throw new RuntimeException("Failed to create target directory for configuration files");
        }
        File krb5ConfFile = new File("target/krb5.conf");
        try (FileWriter writer = new FileWriter(krb5ConfFile);){
            writer.write("[libdefaults]\n");
            writer.write("    default_realm = " + this.testRealm + "\n");
            writer.write("    dns_lookup_kdc = false\n");
            writer.write("    dns_lookup_realm = false\n");
            writer.write("    ticket_lifetime = 24000\n");
            writer.write("    forwardable = yes\n");
            writer.write("    udp_preference_limit = 65536\n");
            writer.write("\n");
            writer.write("[realms]\n");
            writer.write("    " + this.testRealm + " = {\n");
            writer.write("        kdc = " + this.serviceHost + ":" + this.kdcServer.getKdcPort() + "\n");
            writer.write("    }\n");
        }
        File jaasConfigFile = new File("target/jaas.conf");
        try (FileWriter writer = new FileWriter(jaasConfigFile);){
            writer.write("KerberosClient {\n");
            writer.write("    com.sun.security.auth.module.Krb5LoginModule required\n");
            writer.write("    useKeyTab=true\n");
            writer.write("    keyTab=\"" + this.clientKeytab.getAbsolutePath() + "\"\n");
            writer.write("    principal=\"" + this.fullClientPrincipal + "\"\n");
            writer.write("    debug=true;\n");
            writer.write("};\n");
        }
        this.originalKrb5ConfProperty = System.getProperty("java.security.krb5.conf");
        this.originalJaasConfigProperty = System.getProperty("java.security.auth.login.config");
        System.setProperty("java.security.krb5.conf", krb5ConfFile.getAbsolutePath());
        System.setProperty("java.security.auth.login.config", jaasConfigFile.getAbsolutePath());
        LOGGER.debug("krb5.conf: {}", (Object)krb5ConfFile.getAbsolutePath());
        LOGGER.debug("jaas.conf: {}", (Object)jaasConfigFile.getAbsolutePath());
    }

    private void cleanupFiles() {
        if (this.clientKeytab != null && this.clientKeytab.exists() && !this.clientKeytab.delete()) {
            LOGGER.warn("Failed to delete client keytab: {}", (Object)this.clientKeytab.getAbsolutePath());
        }
        if (this.kdcWorkDir != null && this.kdcWorkDir.exists()) {
            this.deleteDirectoryRecursively(this.kdcWorkDir);
        }
    }

    private void deleteDirectoryRecursively(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.deleteDirectoryRecursively(file);
                    continue;
                }
                if (file.delete()) continue;
                LOGGER.warn("Failed to delete file: {}", (Object)file.getAbsolutePath());
            }
        }
        if (!dir.delete()) {
            LOGGER.warn("Failed to delete directory: {}", (Object)dir.getAbsolutePath());
        }
    }

    private void restoreSystemProperties() {
        this.restoreSystemProperty("java.security.krb5.conf", this.originalKrb5ConfProperty);
        this.restoreSystemProperty("java.security.auth.login.config", this.originalJaasConfigProperty);
        System.clearProperty("sun.security.krb5.debug");
        System.clearProperty("sun.security.jgss.debug");
    }

    private void restoreSystemProperty(String key, String originalValue) {
        if (originalValue != null) {
            System.setProperty(key, originalValue);
        } else {
            System.clearProperty(key);
        }
    }

    public SimpleKdcServer getKdcServer() {
        return this.kdcServer;
    }

    public WireMockServer getMockServer() {
        return this.mockServer;
    }

    public File getClientKeytab() {
        return this.clientKeytab;
    }

    public String getTestRealm() {
        return this.testRealm;
    }

    public String getClientPrincipal() {
        return this.clientPrincipal;
    }

    public String getServiceHost() {
        return this.serviceHost;
    }

    public String getFullClientPrincipal() {
        return this.fullClientPrincipal;
    }
}

