/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tls.sni;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.sni.SNIConfig;
import org.glassfish.grizzly.sni.SNIFilter;
import org.glassfish.grizzly.ssl.SSLBaseFilter;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.mule.tls.sni.HttpsRequesterSniTestCase;

public class HttpsTestServerEnforcingSNI {
    private final int port;
    private HttpServer httpServer;
    private SniAddOn sniAddOn;

    public HttpsTestServerEnforcingSNI(int port) {
        this.port = port;
    }

    protected void startServer() throws IOException, URISyntaxException {
        NetworkListener networkListener = new NetworkListener("sample-listener", "localhost", this.port);
        SSLContext sslContext = this.createSSLContextConfigurator().createSSLContext(false);
        SSLEngineConfigurator sslServerEngineConfig = new SSLEngineConfigurator(sslContext, false, false, false);
        networkListener.setSSLEngineConfig(sslServerEngineConfig);
        this.httpServer = new HttpServer();
        this.httpServer.addListener(networkListener);
        networkListener.setSecure(true);
        this.sniAddOn = new SniAddOn(sslServerEngineConfig);
        networkListener.registerAddOn((AddOn)this.sniAddOn);
        this.httpServer.start();
    }

    protected void stopServer() {
        this.sniAddOn.stop();
        this.httpServer.shutdownNow();
    }

    private SSLContextConfigurator createSSLContextConfigurator() throws URISyntaxException {
        URL keystoreUrl;
        SSLContextConfigurator sslContextConfigurator = new SSLContextConfigurator();
        ClassLoader cl = HttpsRequesterSniTestCase.class.getClassLoader();
        URL cacertsUrl = cl.getResource("tls/sni-server-truststore.jks");
        if (cacertsUrl != null) {
            sslContextConfigurator.setTrustStoreFile(new File(cacertsUrl.toURI()).getPath());
            sslContextConfigurator.setTrustStorePass("changeit");
        }
        if ((keystoreUrl = cl.getResource("tls/sni-server-keystore.jks")) != null) {
            sslContextConfigurator.setKeyStoreFile(new File(keystoreUrl.toURI()).getPath());
            sslContextConfigurator.setKeyStorePass("changeit");
            sslContextConfigurator.setKeyPass("changeit");
        }
        return sslContextConfigurator;
    }

    public String getHostname() {
        return this.sniAddOn.getHostname();
    }

    private static class SniAddOn
    implements AddOn {
        private final SSLEngineConfigurator sslServerEngineConfig;
        private final AtomicReference<String> sniHostname = new AtomicReference();

        public SniAddOn(SSLEngineConfigurator sslServerEngineConfig) {
            this.sslServerEngineConfig = sslServerEngineConfig;
        }

        public void setup(NetworkListener networkListener, FilterChainBuilder builder) {
            int idx = builder.indexOfType(SSLBaseFilter.class);
            if (idx != -1) {
                builder.set(idx, (Filter)this.getSniFilter());
            }
        }

        private SNIFilter getSniFilter() {
            Attribute sniHostAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("sni-host-attr");
            SNIFilter sniFilter = new SNIFilter();
            sniFilter.setServerSSLConfigResolver((connection, hostname) -> {
                sniHostAttr.set((AttributeStorage)connection, (Object)hostname);
                this.sniHostname.set(hostname);
                if (StringUtils.isEmpty((CharSequence)hostname)) {
                    throw new IllegalArgumentException("SNI Has not been sent");
                }
                return SNIConfig.newServerConfig((SSLEngineConfigurator)this.sslServerEngineConfig);
            });
            return sniFilter;
        }

        public void stop() {
            this.sniHostname.set("");
        }

        public String getHostname() {
            return this.sniHostname.get();
        }
    }
}

