/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tls;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.mule.tls.fips.DefaultTestConfiguration;

public class TlsTestUtils {
    public static final String J8_262_SSL_ERROR_RESPONSE = "General SSLEngine problem";
    public static final String J8_275_SSL_ERROR_RESPONSE = "Certificate signature validation failed";
    public static final String J11_SSL_ERROR_RESPONSE = "PKIX path building failed";
    public static final String J17_SSL_ERROR_RESPONSE = "PKIX path validation failed";
    public static final String BOUNCY_CASTLE_CERTIFICATE_UNKNOWN_ERROR_MESSAGE = "certificate_unknown";
    protected static final String NETTY_SSL_ERROR_RESPONSE = "Received fatal alert: handshake_failure";
    protected static final String APPROPRIATE_PROTOCOL_ERROR = "No appropriate protocol (protocol is disabled or cipher suites are inappropriate)";
    protected static final String NETTY_APPROPRIATE_PROTOCOL_ERROR = "Received fatal alert: protocol_version";
    private static final String keyPassword = "changeit";
    private static final String protocol = "TLSv1.2";

    public static HttpResponse executeGetRequest(String url) throws IOException, GeneralSecurityException, URISyntaxException {
        HttpClient client = TlsTestUtils.getSecureClient();
        HttpGet getMethod = new HttpGet(url);
        return client.execute((HttpUriRequest)getMethod);
    }

    private static HttpClient getSecureClient() throws IOException, GeneralSecurityException, URISyntaxException {
        CloseableHttpClient secureClient = HttpClients.custom().setSslcontext(TlsTestUtils.getSslContext()).build();
        return secureClient;
    }

    private static SSLContext getSslContext() throws IOException, GeneralSecurityException, URISyntaxException {
        File keyStore = new File(TlsTestUtils.class.getClassLoader().getResource(DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestSslKeyStore()).toURI());
        File trustStore = FileUtils.getFile((File)new File(TlsTestUtils.class.getClassLoader().getResource(DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestSslCaCerts()).toURI()), (String[])new String[0]);
        char[] storePass = DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestStorePassword().toCharArray();
        char[] keyPass = keyPassword.toCharArray();
        SSLContext customSslContext = SSLContexts.custom().setKeyStoreType(DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestStoreType()).useProtocol(protocol).loadKeyMaterial(keyStore, storePass, keyPass).loadTrustMaterial(trustStore, storePass).build();
        return customSslContext;
    }

    public static Matcher<String> sslValidationError() {
        return Matchers.is((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.containsString((String)J8_262_SSL_ERROR_RESPONSE), Matchers.containsString((String)J8_275_SSL_ERROR_RESPONSE), Matchers.containsString((String)J11_SSL_ERROR_RESPONSE), Matchers.containsString((String)J17_SSL_ERROR_RESPONSE), Matchers.containsString((String)NETTY_SSL_ERROR_RESPONSE), Matchers.containsString((String)APPROPRIATE_PROTOCOL_ERROR), Matchers.containsString((String)NETTY_APPROPRIATE_PROTOCOL_ERROR)}));
    }
}

