/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.locator;

import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.test.AbstractIntegrationTestCase;

@Features(value={@Feature(value="Lazy Initialization"), @Feature(value="Configuration component locator")})
@Story(value="Search configuration")
public class LazyInitPropertyInitTestCase
extends AbstractIntegrationTestCase {
    @Inject
    private Registry registry;
    @Inject
    private LazyComponentInitializer lazyComponentInitializer;

    protected String getConfigFile() {
        return "org/mule/test/integration/locator/object-with-property.xml";
    }

    public boolean enableLazyInit() {
        return true;
    }

    @Test
    @Issue(value="MULE-18319")
    public void objectWithProperty() {
        Location testingObjectLocation = Location.builderFromStringRepresentation((String)"testingObject").build();
        this.lazyComponentInitializer.initializeComponent(testingObjectLocation);
        MatcherAssert.assertThat((Object)this.registry.lookupByName("testingObject"), (Matcher)Matchers.notNullValue());
    }
}

