/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.locator;

import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.functional.api.component.LifecycleTrackerConfig;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.test.AbstractIntegrationTestCase;

@Features(value={@Feature(value="Lazy Initialization"), @Feature(value="Configuration component locator")})
@Story(value="Search configuration")
public class LazyInitConfigurationLifecycleTestCase
extends AbstractIntegrationTestCase {
    @Inject
    private LazyComponentInitializer lazyComponentInitializer;

    protected String getConfigFile() {
        return "org/mule/test/integration/locator/component-lifecycle-config.xml";
    }

    public boolean enableLazyInit() {
        return true;
    }

    public boolean disableXmlValidations() {
        return true;
    }

    @Test
    @Issue(value="MULE-18417")
    @Ignore(value="MULE-18566")
    public void nestedConfigLifecycle() {
        this.lazyComponentInitializer.initializeComponents(componentLocation -> componentLocation.getLocation().equals("rootConfig"));
        Optional<LifecycleTrackerConfig> nestedConfig = this.locator.find(Location.builderFromStringRepresentation((String)"rootConfig/0").build()).map(c -> (LifecycleTrackerConfig)c);
        MatcherAssert.assertThat((Object)nestedConfig.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)nestedConfig.get().getTracker(), (Matcher)Matchers.is(Arrays.asList("setMuleContext")));
    }
}

