/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Repeatable Streams")
@Story(value="Routers working with Repeatable Streams")
public class RepeatableStreamingRoutersTestCase
extends AbstractIntegrationTestCase {
    private static final String PAYLOAD = "{\"name\": \"tato\", \"id\": \"42\"}";
    private static final String EXPECTED_OUTPUT = "\"tato - 42\"";
    @Rule
    public DynamicPort listenPort = new DynamicPort("port");

    protected String getConfigFile() {
        return "routers-with-streams-config.xml";
    }

    private void doTest(HttpEntity entity, String endpoint, String expected) throws Exception {
        HttpPost httpPost = new HttpPost(String.format("http://localhost:%s/%s", this.listenPort.getNumber(), endpoint));
        httpPost.setEntity(entity);
        try (CloseableHttpClient client = HttpClients.createDefault();
             CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);){
            MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
            MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)expected));
        }
    }

    @Description(value="Repeatable Streaming works with Scatter Gather Scope - String Payload")
    @Test
    public void scatterGather() throws Exception {
        this.doTest((HttpEntity)new StringEntity(PAYLOAD, ContentType.APPLICATION_JSON), "scatter-gather", EXPECTED_OUTPUT);
    }

    @Description(value="Repeatable Streaming works with Scatter Gather Scope - Byte[] Payload")
    @Test
    public void scatterGatherByteArray() throws Exception {
        this.doTest((HttpEntity)new ByteArrayEntity(PAYLOAD.getBytes(), ContentType.APPLICATION_JSON), "scatter-gather", EXPECTED_OUTPUT);
    }

    @Description(value="Repeatable Streaming works with Async Scope - String Payload")
    @Test
    public void async() throws Exception {
        this.doTest((HttpEntity)new StringEntity(PAYLOAD, ContentType.APPLICATION_JSON), "async", EXPECTED_OUTPUT);
    }

    @Description(value="Repeatable Streaming works with Async Scope - Byte[] Payload")
    @Test
    public void asyncByteArray() throws Exception {
        this.doTest((HttpEntity)new ByteArrayEntity(PAYLOAD.getBytes(), ContentType.APPLICATION_JSON), "async", EXPECTED_OUTPUT);
    }
}

