/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.streaming;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.streaming.StreamingStatistics;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.probe.PollingProber;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Streaming")
@Story(value="Management of Streams")
@Ignore(value="TD-0147155")
public class AutoCloseCursorProviderTestCase
extends AbstractIntegrationTestCase {
    private static final int OPEN_PROVIDERS = 100;
    private static final int TIMEOUT_MILLIS = 10000;
    private static final int POLL_DELAY_MILLIS = 100;
    private static StreamingStatistics statistics;
    @ClassRule
    public static TemporaryFolder temporaryFolder;
    @Rule
    public SystemProperty workingDirSysProp = new SystemProperty("workingDir", temporaryFolder.getRoot().getPath());
    @Inject
    private StreamingManager streamingManager;

    protected String getConfigFile() {
        return "org/mule/streaming/auto-close-cursor-provider-config.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        statistics = this.streamingManager.getStreamingStatistics();
    }

    protected void doTearDown() throws Exception {
        super.doTearDown();
        statistics = null;
    }

    @Test
    public void openManyStreamsInForeachAndDiscard() throws Exception {
        String content = RandomStringUtils.insecure().nextAlphanumeric(0x100000);
        File file = new File(temporaryFolder.getRoot(), "file.txt");
        FileUtils.writeStringToFile((File)file, (String)content, (Charset)StandardCharsets.UTF_8);
        this.flowRunner("openManyStreamsInForeachAndDiscard").run();
        PollingProber.probe((long)10000L, (long)100L, () -> {
            MatcherAssert.assertThat((String)"Leaked Cursor Providers", (Object)statistics.getOpenCursorProvidersCount(), (Matcher)CoreMatchers.is((Object)0));
            MatcherAssert.assertThat((String)"Leaked Cursors", (Object)statistics.getOpenCursorsCount(), (Matcher)CoreMatchers.is((Object)0));
            return true;
        });
    }

    protected boolean isGracefulShutdown() {
        return true;
    }

    static {
        temporaryFolder = new TemporaryFolder();
    }

    public static class AssertStatisticsProcessor
    extends AbstractComponent
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            PollingProber.probe((long)10000L, (long)100L, () -> {
                System.gc();
                MatcherAssert.assertThat((Object)statistics.getClass().getName(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"NullStreamingStatistics")));
                MatcherAssert.assertThat((String)"No cursor provider reclaimed", (Object)statistics.getOpenCursorProvidersCount(), (Matcher)CoreMatchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(100))));
                return true;
            });
            return event;
        }
    }
}

